/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;

public class QrConfig {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    protected int width;
    protected int height;
    protected Integer foreColor = -16777216;
    protected Integer backColor = -1;
    protected Integer margin = 2;
    protected Integer qrVersion;
    protected ErrorCorrectionLevel errorCorrection = ErrorCorrectionLevel.M;
    protected Charset charset = CharsetUtil.CHARSET_UTF_8;
    protected Image img;
    protected int ratio = 6;
    protected SymbolShapeHint shapeHint = SymbolShapeHint.FORCE_NONE;

    public static QrConfig create() {
        return new QrConfig();
    }

    public QrConfig() {
        this(300, 300);
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig(int width, int height) {
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setWidth(int width) {
        void var1_1;
        this.width = var1_1;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setHeight(int height) {
        void var1_1;
        this.height = var1_1;
        return this;
    }

    public int getForeColor() {
        return this.foreColor;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public QrConfig setForeColor(int foreColor) {
        void var1_1;
        this.foreColor = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setForeColor(Color foreColor) {
        void var1_1;
        this.foreColor = foreColor == null ? null : Integer.valueOf(var1_1.getRGB());
        return this;
    }

    public int getBackColor() {
        return this.backColor;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public QrConfig setBackColor(int backColor) {
        void var1_1;
        this.backColor = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setBackColor(Color backColor) {
        void var1_1;
        this.backColor = backColor == null ? null : Integer.valueOf(var1_1.getRGB());
        return this;
    }

    public Integer getMargin() {
        return this.margin;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setMargin(Integer margin) {
        void var1_1;
        this.margin = var1_1;
        return this;
    }

    public Integer getQrVersion() {
        return this.qrVersion;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setQrVersion(Integer qrVersion) {
        void var1_1;
        this.qrVersion = var1_1;
        return this;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        return this.errorCorrection;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        void var1_1;
        this.errorCorrection = var1_1;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    public Image getImg() {
        return this.img;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setImg(String imgPath) {
        void var1_1;
        return this.setImg(FileUtil.file((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setImg(File imgFile) {
        void var1_1;
        return this.setImg(ImgUtil.read((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setImg(Image img) {
        void var1_1;
        this.img = var1_1;
        return this;
    }

    public int getRatio() {
        return this.ratio;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setRatio(int ratio) {
        void var1_1;
        this.ratio = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public QrConfig setShapeHint(SymbolShapeHint shapeHint) {
        void var1_1;
        this.shapeHint = var1_1;
        return this;
    }

    public HashMap<EncodeHintType, Object> toHints() {
        return this.toHints(BarcodeFormat.QR_CODE);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<EncodeHintType, Object> toHints(BarcodeFormat format) {
        void var2_2;
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        if (this.charset != null) {
            hints.put(EncodeHintType.CHARACTER_SET, this.charset.toString().toLowerCase());
        }
        if (this.errorCorrection != null) {
            void var1_1;
            Integer value = BarcodeFormat.AZTEC == format || BarcodeFormat.PDF_417 == format ? Integer.valueOf(this.errorCorrection.getBits()) : this.errorCorrection;
            hints.put(EncodeHintType.ERROR_CORRECTION, var1_1);
            hints.put(EncodeHintType.DATA_MATRIX_SHAPE, this.shapeHint);
        }
        if (this.margin != null) {
            hints.put(EncodeHintType.MARGIN, this.margin);
        }
        if (this.qrVersion != null) {
            hints.put(EncodeHintType.QR_VERSION, this.qrVersion);
        }
        return var2_2;
    }
}

