/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.img.Img;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.ansi.AnsiColors;
import cn.hutool.core.lang.ansi.AnsiElement;
import cn.hutool.core.lang.ansi.AnsiEncoder;
import cn.hutool.core.lang.ansi.ForeOrBack;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import cn.hutool.extra.qrcode.QrCodeException;
import cn.hutool.extra.qrcode.QrConfig;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class QrCodeUtil {
    public static final String QR_TYPE_SVG = "svg";
    public static final String QR_TYPE_TXT = "txt";
    private static final AnsiColors ansiColors = new AnsiColors(AnsiColors.BitDepth.EIGHT);

    /*
     * WARNING - void declaration
     */
    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType, String logoBase64) {
        void var3_3;
        void var2_2;
        void var1_1;
        return QrCodeUtil.generateAsBase64(content, (QrConfig)var1_1, (String)var2_2, Base64.decode((CharSequence)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType, byte[] logo) {
        void var3_3;
        void var2_2;
        void var1_1;
        return QrCodeUtil.generateAsBase64(content, (QrConfig)var1_1, (String)var2_2, ImgUtil.toImage((byte[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType, Image logo) {
        void var2_2;
        void var1_1;
        String string;
        void var3_3;
        qrConfig.setImg((Image)var3_3);
        return QrCodeUtil.generateAsBase64(string, (QrConfig)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAsBase64(String content, QrConfig qrConfig, String targetType) {
        Object object;
        switch (targetType) {
            case "svg": {
                content = QrCodeUtil.generateAsSvg(content, qrConfig);
                Object result = QrCodeUtil.svgToBase64(content);
                break;
            }
            case "txt": {
                Object result;
                result = QrCodeUtil.generateAsAsciiArt((String)result, qrConfig);
                result = QrCodeUtil.txtToBase64((String)result);
                break;
            }
            default: {
                void var2_2;
                void var1_1;
                Object result;
                result = QrCodeUtil.generate((String)result, (QrConfig)var1_1);
                result = ImgUtil.toBase64DataUri((Image)result, (String)var2_2);
            }
        }
        return object;
    }

    private static String txtToBase64(String txt) {
        String string;
        return URLUtil.getDataUri("text/plain", "base64", Base64.encode(string));
    }

    private static String svgToBase64(String svg) {
        String string;
        return URLUtil.getDataUri("image/svg+xml", "base64", Base64.encode(string));
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAsSvg(String content, QrConfig qrConfig) {
        void var1_1;
        String string = QrCodeUtil.encode(content, qrConfig);
        return QrCodeUtil.toSVG((BitMatrix)string, (QrConfig)var1_1);
    }

    public static String generateAsAsciiArt(String content) {
        return QrCodeUtil.generateAsAsciiArt(content, 0, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAsAsciiArt(String content, QrConfig qrConfig) {
        void var1_1;
        String string = QrCodeUtil.encode(content, qrConfig);
        return QrCodeUtil.toAsciiArt((BitMatrix)string, (QrConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAsAsciiArt(String content, int width, int height, int margin) {
        void var1_2;
        String string;
        void var3_4;
        void var2_3;
        QrConfig qrConfig = new QrConfig(width, (int)var2_3).setMargin((int)var3_4);
        return QrCodeUtil.generateAsAsciiArt(string, (QrConfig)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] generatePng(String content, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(string, (int)var1_1, (int)var2_2, "png", out);
        return var3_3.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] generatePng(String content, QrConfig config) {
        void var2_2;
        void var1_1;
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(string, (QrConfig)var1_1, "png", out);
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static File generate(String content, int width, int height, File targetFile) {
        void var3_3;
        switch (FileUtil.extName(targetFile)) {
            case "svg": {
                content = QrCodeUtil.generateAsSvg(content, new QrConfig(width, height));
                FileUtil.writeString(content, targetFile, StandardCharsets.UTF_8);
                break;
            }
            case "txt": {
                content = QrCodeUtil.generateAsAsciiArt(content, new QrConfig(width, height));
                FileUtil.writeString(content, targetFile, StandardCharsets.UTF_8);
                break;
            }
            default: {
                void var2_2;
                void var1_1;
                BufferedImage bufferedImage;
                bufferedImage = QrCodeUtil.generate((String)((Object)bufferedImage), (int)var1_1, (int)var2_2);
                ImgUtil.write(bufferedImage, targetFile);
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static File generate(String content, QrConfig config, File targetFile) {
        void var2_2;
        switch (FileUtil.extName(targetFile)) {
            case "svg": {
                content = QrCodeUtil.generateAsSvg(content, config);
                FileUtil.writeString(content, targetFile, StandardCharsets.UTF_8);
                break;
            }
            case "txt": {
                content = QrCodeUtil.generateAsAsciiArt(content, config);
                FileUtil.writeString(content, targetFile, StandardCharsets.UTF_8);
                break;
            }
            default: {
                void var1_1;
                BufferedImage bufferedImage;
                bufferedImage = QrCodeUtil.generate((String)((Object)bufferedImage), (QrConfig)var1_1);
                ImgUtil.write(bufferedImage, targetFile);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static void generate(String content, int width, int height, String targetType, OutputStream out) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        switch (targetType) {
            case "svg": {
                String svg = QrCodeUtil.generateAsSvg(content, new QrConfig(width, height));
                IoUtil.writeUtf8(out, false, svg);
                return;
            }
            case "txt": {
                String svg;
                String txt = QrCodeUtil.generateAsAsciiArt(svg, new QrConfig(width, height));
                IoUtil.writeUtf8(out, false, string);
                return;
            }
        }
        string = QrCodeUtil.generate(string, (int)var1_1, (int)var2_2);
        ImgUtil.write((Image)((Object)string), (String)var3_3, out);
    }

    /*
     * WARNING - void declaration
     */
    public static void generate(String content, QrConfig config, String targetType, OutputStream out) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        switch (targetType) {
            case "svg": {
                String svg = QrCodeUtil.generateAsSvg(content, config);
                IoUtil.writeUtf8(out, false, svg);
                return;
            }
            case "txt": {
                String svg;
                String txt = QrCodeUtil.generateAsAsciiArt(svg, config);
                IoUtil.writeUtf8(out, false, string);
                return;
            }
        }
        string = QrCodeUtil.generate(string, (QrConfig)var1_1);
        ImgUtil.write((Image)((Object)string), (String)var2_2, (OutputStream)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage generate(String content, int width, int height) {
        void var2_2;
        void var1_1;
        return QrCodeUtil.generate(content, new QrConfig((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage generate(String content, BarcodeFormat format, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return QrCodeUtil.generate(content, (BarcodeFormat)var1_1, new QrConfig((int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage generate(String content, QrConfig config) {
        void var1_1;
        return QrCodeUtil.generate(content, BarcodeFormat.QR_CODE, (QrConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedImage generate(String content, BarcodeFormat format, QrConfig config) {
        BufferedImage bufferedImage;
        content = QrCodeUtil.encode(content, format, config);
        BufferedImage image = QrCodeUtil.toImage((BitMatrix)content, config.foreColor != null ? config.foreColor.intValue() : Color.BLACK.getRGB(), config.backColor);
        Image logoImg = config.img;
        if (logoImg != null && BarcodeFormat.QR_CODE == format) {
            void var2_4;
            void var1_2;
            void var3_5;
            int height2;
            int width;
            int qrHeight;
            int qrWidth = image.getWidth();
            if (qrWidth < (qrHeight = image.getHeight())) {
                width = qrWidth / config.ratio;
                height2 = logoImg.getHeight(null) * width / logoImg.getWidth(null);
            } else {
                void height;
                height2 = qrHeight / height.ratio;
                width = logoImg.getWidth(null) * height2 / logoImg.getHeight(null);
            }
            Img.from(image).pressImage(Img.from((Image)var3_5).round(0.3).getImg(), new Rectangle((int)var1_2, (int)var2_4), 1.0f);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public static BitMatrix encode(String content, int width, int height) {
        void var2_2;
        void var1_1;
        return QrCodeUtil.encode(content, BarcodeFormat.QR_CODE, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BitMatrix encode(String content, QrConfig config) {
        void var1_1;
        return QrCodeUtil.encode(content, BarcodeFormat.QR_CODE, (QrConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return QrCodeUtil.encode(content, (BarcodeFormat)var1_1, new QrConfig((int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static BitMatrix encode(String content, BarcodeFormat format, QrConfig config) {
        String string;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        if (config == null) {
            config = new QrConfig();
        }
        try {
            void var1_2;
            void var2_3;
            void var3_4;
            String bitMatrix = var3_4.encode(content, format, config.width, config.height, var2_3.toHints((BarcodeFormat)var1_2));
        }
        catch (WriterException e) {
            throw new QrCodeException(e);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(InputStream qrCodeInputStream) {
        String string;
        BufferedImage image = null;
        try {
            image = ImgUtil.read((InputStream)((Object)string));
            string = QrCodeUtil.decode(image);
        }
        catch (Throwable throwable) {
            void var1_2;
            ImgUtil.flush((Image)var1_2);
            throw throwable;
        }
        ImgUtil.flush(image);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(File qrCodeFile) {
        String string;
        BufferedImage image = null;
        try {
            image = ImgUtil.read((File)((Object)string));
            string = QrCodeUtil.decode(image);
        }
        catch (Throwable throwable) {
            void var1_2;
            ImgUtil.flush((Image)var1_2);
            throw throwable;
        }
        ImgUtil.flush(image);
        return string;
    }

    public static String decode(Image image) {
        return QrCodeUtil.decode(image, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        void var2_2;
        void var1_1;
        return QrCodeUtil.decode(image, QrCodeUtil.buildHints((boolean)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        MultiFormatReader formatReader = new MultiFormatReader();
        formatReader.setHints(hints);
        Object source = new BufferedImageLuminanceSource(ImgUtil.toBufferedImage(image));
        Result result = QrCodeUtil._decode(formatReader, (Binarizer)new HybridBinarizer((LuminanceSource)source));
        if (result == null) {
            Object object;
            void var2_2;
            result = QrCodeUtil._decode((MultiFormatReader)var2_2, (Binarizer)new GlobalHistogramBinarizer((LuminanceSource)object));
        }
        if (result != null) {
            void var1_1;
            return var1_1.getText();
        }
        return null;
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, backColor == null ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (backColor == null) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    public static String toSVG(BitMatrix matrix, QrConfig qrConfig) {
        void var1_1;
        return QrCodeUtil.toSVG(matrix, qrConfig.foreColor, qrConfig.backColor, qrConfig.img, var1_1.getRatio());
    }

    /*
     * WARNING - void declaration
     */
    public static String toSVG(BitMatrix matrix, Integer foreColor, Integer backColor, Image logoImg, int ratio) {
        void var3_4;
        StringBuilder sb = new StringBuilder();
        int qrWidth = matrix.getWidth();
        int qrHeight = matrix.getHeight();
        int moduleHeight = qrHeight == 1 ? qrWidth / 2 : 1;
        for (int y = 0; y < qrHeight; ++y) {
            for (int x = 0; x < qrWidth; ++x) {
                if (!matrix.get(x, y)) continue;
                sb.append(" M").append(x).append(",").append(y).append("h1v").append(moduleHeight).append("h-1z");
            }
        }
        qrHeight *= moduleHeight;
        String logoBase64 = "";
        int logoWidth = 0;
        int logoHeight = 0;
        int logoX = 0;
        int logoY = 0;
        if (logoImg != null) {
            logoBase64 = ImgUtil.toBase64DataUri(logoImg, "png");
            if (qrWidth < qrHeight) {
                logoWidth = qrWidth / ratio;
                logoHeight = logoImg.getHeight(null) * logoWidth / logoImg.getWidth(null);
            } else {
                logoHeight = qrHeight / ratio;
                logoWidth = logoImg.getWidth(null) * logoHeight / logoImg.getHeight(null);
            }
            logoX = (qrWidth - logoWidth) / 2;
            logoY = (qrHeight - logoHeight) / 2;
        }
        StringBuilder result = StrUtil.builder();
        result.append("<svg width=\"").append(qrWidth).append("\" height=\"").append(qrHeight).append("\" \n");
        if (backColor != null) {
            Color back = new Color(backColor, true);
            result.append("style=\"background-color:rgba(").append(back.getRed()).append(",").append(back.getGreen()).append(",").append(back.getBlue()).append(",").append(back.getAlpha()).append(")\"\n");
        }
        result.append("viewBox=\"0 0 ").append(qrWidth).append(" ").append(qrHeight).append("\" \n");
        result.append("xmlns=\"http://www.w3.org/2000/svg\" \n");
        result.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" >\n");
        result.append("<path d=\"").append((CharSequence)sb).append("\" ");
        if (foreColor != null) {
            void var2_3;
            void var1_2;
            Color fore = new Color(var1_2.intValue(), true);
            result.append("stroke=\"rgba(").append(fore.getRed()).append(",").append(fore.getGreen()).append(",").append(fore.getBlue()).append(",").append(var2_3.getAlpha()).append(")\"");
        }
        result.append(" /> \n");
        if (StrUtil.isNotBlank(logoBase64)) {
            void var0_1;
            result.append("<image xlink:href=\"").append(logoBase64).append("\" height=\"").append((int)var0_1).append("\" width=\"").append(logoWidth).append("\" y=\"").append(logoY).append("\" x=\"").append(logoX).append("\" />\n");
        }
        result.append("</svg>");
        return var3_4.toString();
    }

    public static String toAsciiArt(BitMatrix bitMatrix, QrConfig qrConfig) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        AnsiElement foreground = qrConfig.foreColor == null ? null : QrCodeUtil.rgbToAnsi8BitElement(qrConfig.foreColor, ForeOrBack.FORE);
        AnsiElement background = qrConfig.backColor == null ? null : QrCodeUtil.rgbToAnsi8BitElement(qrConfig.backColor, ForeOrBack.BACK);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= height; i += 2) {
            StringBuilder rowBuilder = new StringBuilder();
            for (int j = 0; j < width; ++j) {
                boolean bt;
                boolean tp = bitMatrix.get(i, j);
                boolean bl = bt = i + 1 >= height || bitMatrix.get(i + 1, j);
                if (tp && bt) {
                    rowBuilder.append(' ');
                    continue;
                }
                if (tp) {
                    rowBuilder.append('\u2584');
                    continue;
                }
                if (bt) {
                    rowBuilder.append('\u2580');
                    continue;
                }
                rowBuilder.append('\u2588');
            }
            builder.append(AnsiEncoder.encode(foreground, background, rowBuilder)).append('\n');
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static AnsiElement rgbToAnsi8BitElement(int rgb, ForeOrBack foreOrBack) {
        void var1_1;
        int n;
        return ansiColors.findClosest(new Color(n)).toAnsiElement((ForeOrBack)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<DecodeHintType, Object> buildHints(boolean isTryHarder, boolean isPureBarcode) {
        void var2_2;
        void var1_1;
        boolean bl;
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        if (bl) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (var1_1 != false) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Result _decode(MultiFormatReader formatReader, Binarizer binarizer) {
        try {
            void var1_1;
            return formatReader.decodeWithState(new BinaryBitmap((Binarizer)var1_1));
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }
}

