/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import com.google.zxing.LuminanceSource;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public final class BufferedImageLuminanceSource
extends LuminanceSource {
    private final BufferedImage image;
    private final int left;
    private final int top;

    /*
     * WARNING - void declaration
     */
    public BufferedImageLuminanceSource(BufferedImage image) {
        this(image, 0, 0, image.getWidth(), var1_1.getHeight());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImageLuminanceSource(BufferedImage image, int left, int top, int width, int height) {
        super(width, height);
        void var3_3;
        void var2_2;
        void var1_1;
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (left + width > sourceWidth || top + height > sourceHeight) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        for (int y = top; y < top + height; ++y) {
            for (int x = left; x < left + width; ++x) {
                if ((image.getRGB(x, y) & 0xFF000000) != 0) continue;
                image.setRGB(x, y, -1);
            }
        }
        this.image = new BufferedImage(sourceWidth, sourceHeight, 10);
        this.image.getGraphics().drawImage((Image)var1_1, 0, 0, null);
        this.left = var2_2;
        this.top = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] getRow(int y, byte[] row) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + y);
        }
        int width = this.getWidth();
        if (row == null || row.length < width) {
            row = new byte[width];
        }
        this.image.getRaster().getDataElements(this.left, this.top + var1_1, (int)var3_3, 1, row);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] getMatrix() {
        void var3_4;
        void var2_2;
        void var1_1;
        int width = this.getWidth();
        int height = this.getHeight();
        int n = width * height;
        byte[] matrix = new byte[n];
        this.image.getRaster().getDataElements(this.left, this.top, (int)var1_1, (int)var2_2, matrix);
        return var3_4;
    }

    public final boolean isCropSupported() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final LuminanceSource crop(int left, int top, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new BufferedImageLuminanceSource(this.image, this.left + var1_1, this.top + var2_2, (int)var3_3, height);
    }

    public final boolean isRotateSupported() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final LuminanceSource rotateCounterClockwise() {
        void var3_5;
        void var1_1;
        void var2_3;
        int sourceWidth = this.image.getWidth();
        int sourceHeight = this.image.getHeight();
        AffineTransform transform = new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, (double)sourceWidth);
        BufferedImage rotatedImage = new BufferedImage(sourceHeight, sourceWidth, 10);
        Graphics2D g = rotatedImage.createGraphics();
        g.drawImage(this.image, transform, null);
        g.dispose();
        int width = this.getWidth();
        return new BufferedImageLuminanceSource((BufferedImage)var2_3, this.top, (int)(var1_1 - (this.left + width)), this.getHeight(), (int)var3_5);
    }
}

