/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.pinyin.engine.pinyin4j;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinEngine;
import cn.hutool.extra.pinyin.PinyinException;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Pinyin4jEngine
implements PinyinEngine {
    HanyuPinyinOutputFormat format;

    public Pinyin4jEngine() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public Pinyin4jEngine(HanyuPinyinOutputFormat format) {
        void var1_1;
        this.init((HanyuPinyinOutputFormat)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void init(HanyuPinyinOutputFormat format) {
        void var1_1;
        if (format == null) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
        this.format = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPinyin(char c) {
        void var2_2;
        String result;
        try {
            String[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            result = ArrayUtil.isEmpty(results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            void var1_1;
            result = String.valueOf((char)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPinyin(String str, String separator) {
        void var3_3;
        StrBuilder result = StrUtil.strBuilder();
        boolean isFirst = true;
        int strLen = str.length();
        try {
            for (int i = 0; i < strLen; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append(separator);
                }
                String[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i), (HanyuPinyinOutputFormat)this.format);
                if (ArrayUtil.isEmpty(pinyinStringArray)) {
                    result.append(str.charAt(i));
                    continue;
                }
                result.append(pinyinStringArray[0]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new PinyinException(e);
        }
        return var3_3.toString();
    }
}

