/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.InternalMailUtil;
import cn.hutool.setting.Setting;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MailAccount
implements Serializable {
    private static final long serialVersionUID = -6937313421815719204L;
    private static final String MAIL_PROTOCOL = "mail.transport.protocol";
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String SMTP_TIMEOUT = "mail.smtp.timeout";
    private static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String SMTP_WRITE_TIMEOUT = "mail.smtp.writetimeout";
    private static final String STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String SSL_ENABLE = "mail.smtp.ssl.enable";
    private static final String SSL_PROTOCOLS = "mail.smtp.ssl.protocols";
    private static final String SOCKET_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String SOCKET_FACTORY_PORT = "smtp.socketFactory.port";
    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private static final String MAIL_DEBUG = "mail.debug";
    public static final String[] MAIL_SETTING_PATHS = new String[]{"config/mail.setting", "config/mailAccount.setting", "mail.setting"};
    private String host;
    private Integer port;
    private Boolean auth;
    private String user;
    private String pass;
    private String from;
    private boolean debug;
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private boolean splitlongparameters = false;
    private boolean encodefilename = true;
    private boolean starttlsEnable = false;
    private Boolean sslEnable;
    private String sslProtocols;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback;
    private int socketFactoryPort = 465;
    private long timeout;
    private long connectionTimeout;
    private long writeTimeout;
    private final Map<String, Object> customProperty = new HashMap<String, Object>();

    public MailAccount() {
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount(String settingPath) {
        this(new Setting((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount(Setting setting) {
        void var1_1;
        var1_1.toBean(this);
    }

    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setHost(String host) {
        void var1_1;
        this.host = var1_1;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setPort(Integer port) {
        void var1_1;
        this.port = var1_1;
        return this;
    }

    public Boolean isAuth() {
        return this.auth;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setAuth(boolean isAuth) {
        void var1_1;
        this.auth = (boolean)var1_1;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setUser(String user) {
        void var1_1;
        this.user = var1_1;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setPass(String pass) {
        void var1_1;
        this.pass = var1_1;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setFrom(String from) {
        void var1_1;
        this.from = var1_1;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setDebug(boolean debug) {
        void var1_1;
        this.debug = var1_1;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    public boolean isSplitlongparameters() {
        return this.splitlongparameters;
    }

    /*
     * WARNING - void declaration
     */
    public void setSplitlongparameters(boolean splitlongparameters) {
        void var1_1;
        this.splitlongparameters = var1_1;
    }

    public boolean isEncodefilename() {
        return this.encodefilename;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncodefilename(boolean encodefilename) {
        void var1_1;
        this.encodefilename = var1_1;
    }

    public boolean isStarttlsEnable() {
        return this.starttlsEnable;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setStarttlsEnable(boolean startttlsEnable) {
        void var1_1;
        this.starttlsEnable = var1_1;
        return this;
    }

    public Boolean isSslEnable() {
        return this.sslEnable;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setSslEnable(Boolean sslEnable) {
        void var1_1;
        this.sslEnable = var1_1;
        return this;
    }

    public String getSslProtocols() {
        return this.sslProtocols;
    }

    /*
     * WARNING - void declaration
     */
    public void setSslProtocols(String sslProtocols) {
        void var1_1;
        this.sslProtocols = var1_1;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setSocketFactoryClass(String socketFactoryClass) {
        void var1_1;
        this.socketFactoryClass = var1_1;
        return this;
    }

    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setSocketFactoryFallback(boolean socketFactoryFallback) {
        void var1_1;
        this.socketFactoryFallback = var1_1;
        return this;
    }

    public int getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setSocketFactoryPort(int socketFactoryPort) {
        void var1_1;
        this.socketFactoryPort = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setTimeout(long timeout) {
        void var1_1;
        this.timeout = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setConnectionTimeout(long connectionTimeout) {
        void var1_1;
        this.connectionTimeout = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setWriteTimeout(long writeTimeout) {
        void var1_1;
        this.writeTimeout = var1_1;
        return this;
    }

    public Map<String, Object> getCustomProperty() {
        return this.customProperty;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount setCustomProperty(String key, Object value) {
        if (StrUtil.isNotBlank(key) && ObjectUtil.isNotNull(value)) {
            void var2_2;
            void var1_1;
            this.customProperty.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getSmtpProps() {
        void var1_1;
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(this.splitlongparameters));
        Properties p = new Properties();
        p.put(MAIL_PROTOCOL, "smtp");
        p.put(SMTP_HOST, this.host);
        p.put(SMTP_PORT, String.valueOf(this.port));
        p.put(SMTP_AUTH, String.valueOf(this.auth));
        if (this.timeout > 0L) {
            p.put(SMTP_TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.connectionTimeout > 0L) {
            p.put(SMTP_CONNECTION_TIMEOUT, String.valueOf(this.connectionTimeout));
        }
        if (this.writeTimeout > 0L) {
            p.put(SMTP_WRITE_TIMEOUT, String.valueOf(this.writeTimeout));
        }
        p.put(MAIL_DEBUG, String.valueOf(this.debug));
        if (this.starttlsEnable) {
            p.put(STARTTLS_ENABLE, "true");
            if (this.sslEnable == null) {
                this.sslEnable = Boolean.TRUE;
            }
        }
        if (this.sslEnable != null && this.sslEnable.booleanValue()) {
            p.put(SSL_ENABLE, "true");
            p.put(SOCKET_FACTORY, this.socketFactoryClass);
            p.put(SOCKET_FACTORY_FALLBACK, String.valueOf(this.socketFactoryFallback));
            p.put(SOCKET_FACTORY_PORT, String.valueOf(this.socketFactoryPort));
            if (StrUtil.isNotBlank(this.sslProtocols)) {
                p.put(SSL_PROTOCOLS, this.sslProtocols);
            }
        }
        p.putAll(this.customProperty);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MailAccount defaultIfEmpty() {
        String fromAddress = InternalMailUtil.parseFirstAddress(this.from, this.charset).getAddress();
        if (StrUtil.isBlank(this.host)) {
            Object[] objectArray = new Object[1];
            String string = fromAddress;
            objectArray[0] = StrUtil.subSuf(string, string.indexOf(64) + 1);
            this.host = StrUtil.format("smtp.{}", objectArray);
        }
        if (StrUtil.isBlank(this.user)) {
            void var1_1;
            this.user = var1_1;
        }
        if (this.auth == null) {
            this.auth = false == StrUtil.isBlank(this.pass);
        }
        if (this.port == null) {
            this.port = this.sslEnable != null && this.sslEnable != false ? this.socketFactoryPort : 25;
        }
        if (this.charset == null) {
            this.charset = CharsetUtil.CHARSET_UTF_8;
        }
        return this;
    }

    public String toString() {
        return "MailAccount [host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", user=" + this.user + ", pass=" + (StrUtil.isEmpty(this.pass) ? "" : "******") + ", from=" + this.from + ", startttlsEnable=" + this.starttlsEnable + ", socketFactoryClass=" + this.socketFactoryClass + ", socketFactoryFallback=" + this.socketFactoryFallback + ", socketFactoryPort=" + this.socketFactoryPort + "]";
    }
}

