/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.GlobalMailAccount;
import cn.hutool.extra.mail.InternalMailUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailException;
import cn.hutool.extra.mail.MailUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;

public class Mail
implements Builder<MimeMessage> {
    private static final long serialVersionUID = 1L;
    private final MailAccount mailAccount;
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String[] reply;
    private String title;
    private String content;
    private boolean isHtml;
    private final Multipart multipart = new MimeMultipart();
    private boolean useGlobalSession = false;
    private PrintStream debugOutput;

    public static Mail create(MailAccount mailAccount) {
        MailAccount mailAccount2;
        return new Mail(mailAccount2);
    }

    public static Mail create() {
        return new Mail();
    }

    public Mail() {
        this(GlobalMailAccount.INSTANCE.getAccount());
    }

    /*
     * WARNING - void declaration
     */
    public Mail(MailAccount mailAccount) {
        void var1_1;
        mailAccount = mailAccount != null ? mailAccount : GlobalMailAccount.INSTANCE.getAccount();
        this.mailAccount = var1_1.defaultIfEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public Mail to(String ... tos) {
        void var1_1;
        return this.setTos((String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Mail setTos(String ... tos) {
        void var1_1;
        this.tos = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setCcs(String ... ccs) {
        void var1_1;
        this.ccs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setBccs(String ... bccs) {
        void var1_1;
        this.bccs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setReply(String ... reply) {
        void var1_1;
        this.reply = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setTitle(String title) {
        void var1_1;
        this.title = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setContent(String content) {
        void var1_1;
        this.content = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setHtml(boolean isHtml) {
        void var1_1;
        this.isHtml = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setContent(String content, boolean isHtml) {
        void var2_2;
        void var1_1;
        this.setContent((String)var1_1);
        return this.setHtml((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Mail setFiles(File ... files) {
        void var2_2;
        if (ArrayUtil.isEmpty(files)) {
            return this;
        }
        DataSource[] attachments = new DataSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            attachments[i] = new FileDataSource(files[i]);
        }
        return this.setAttachments((DataSource[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Mail setAttachments(DataSource ... attachments) {
        if (ArrayUtil.isNotEmpty(attachments)) {
            Charset charset = this.mailAccount.getCharset();
            try {
                DataSource[] dataSourceArray = attachments;
                int n = attachments.length;
                for (int i = 0; i < n; ++i) {
                    void var1_1;
                    DataSource attachment = dataSourceArray[i];
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler(attachment));
                    String nameEncoded = attachment.getName();
                    if (this.mailAccount.isEncodefilename()) {
                        nameEncoded = InternalMailUtil.encodeText(nameEncoded, charset);
                    }
                    bodyPart.setFileName(nameEncoded);
                    if (StrUtil.startWith((CharSequence)attachment.getContentType(), "image/")) {
                        void var3_7;
                        bodyPart.setContentID((String)var3_7);
                    }
                    this.multipart.addBodyPart((BodyPart)var1_1);
                }
            }
            catch (MessagingException e) {
                throw new MailException(e);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail addImage(String cid, InputStream imageStream) {
        void var2_2;
        void var1_1;
        return this.addImage((String)var1_1, (InputStream)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public Mail addImage(String cid, InputStream imageStream, String contentType) {
        void var2_3;
        void var1_1;
        ByteArrayDataSource imgSource;
        try {
            void var3_4;
            imgSource = new ByteArrayDataSource(imageStream, ObjectUtil.defaultIfNull(var3_4, "image/jpeg"));
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        imgSource.setName((String)var1_1);
        return this.setAttachments(new DataSource[]{var2_3});
    }

    /*
     * WARNING - void declaration
     */
    public Mail addImage(String cid, File imageFile) {
        Mail mail;
        BufferedInputStream in = null;
        try {
            void var2_3;
            in = FileUtil.getInputStream(imageFile);
            mail = this.addImage((String)((Object)mail), in, FileTypeMap.getDefaultFileTypeMap().getContentType((File)var2_3));
        }
        catch (Throwable throwable) {
            void var3_4;
            IoUtil.close((Closeable)var3_4);
            throw throwable;
        }
        IoUtil.close(in);
        return mail;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setCharset(Charset charset) {
        void var1_1;
        this.mailAccount.setCharset((Charset)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setUseGlobalSession(boolean isUseGlobalSession) {
        void var1_1;
        this.useGlobalSession = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Mail setDebugOutput(PrintStream debugOutput) {
        void var1_1;
        this.debugOutput = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MimeMessage build() {
        try {
            return this.buildMsg();
        }
        catch (MessagingException e) {
            void var1_1;
            throw new MailException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String send() throws MailException {
        try {
            return this.doSend();
        }
        catch (MessagingException messagingException) {
            void var1_1;
            MessagingException e = messagingException;
            if (messagingException instanceof SendFailedException) {
                void var2_2;
                Address[] invalidAddresses = ((SendFailedException)e).getInvalidAddresses();
                String msg = StrUtil.format("Invalid Addresses: {}", ArrayUtil.toString(invalidAddresses));
                throw new MailException((String)var2_2, e);
            }
            throw new MailException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String doSend() throws MessagingException {
        void var1_1;
        MimeMessage mimeMessage = this.buildMsg();
        Transport.send((Message)mimeMessage);
        return var1_1.getMessageID();
    }

    /*
     * WARNING - void declaration
     */
    private MimeMessage buildMsg() throws MessagingException {
        void var2_2;
        Charset charset = this.mailAccount.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession());
        String from = this.mailAccount.getFrom();
        if (StrUtil.isEmpty(from)) {
            msg.setFrom();
        } else {
            void var3_3;
            msg.setFrom((Address)InternalMailUtil.parseFirstAddress((String)var3_3, charset));
        }
        msg.setSubject(this.title, charset == null ? null : charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent(charset));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMailUtil.parseAddressFromStrs(this.tos, charset));
        if (ArrayUtil.isNotEmpty(this.ccs)) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMailUtil.parseAddressFromStrs(this.ccs, charset));
        }
        if (ArrayUtil.isNotEmpty(this.bccs)) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMailUtil.parseAddressFromStrs(this.bccs, charset));
        }
        if (ArrayUtil.isNotEmpty(this.reply)) {
            void var1_1;
            msg.setReplyTo((Address[])InternalMailUtil.parseAddressFromStrs(this.reply, (Charset)var1_1));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Multipart buildContent(Charset charset) throws MessagingException {
        void var2_2;
        void var1_1;
        String charsetStr = charset != null ? charset.name() : MimeUtility.getDefaultJavaCharset();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, StrUtil.format("text/{}; charset={}", this.isHtml ? "html" : "plain", var1_1));
        this.multipart.addBodyPart((BodyPart)var2_2);
        return this.multipart;
    }

    /*
     * WARNING - void declaration
     */
    private Session getSession() {
        void var1_1;
        Session session = MailUtil.getSession(this.mailAccount, this.useGlobalSession);
        if (this.debugOutput != null) {
            session.setDebugOut(this.debugOutput);
        }
        return var1_1;
    }
}

