/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.NetUtil;
import cn.hutool.extra.ftp.FtpException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class SimpleFtpServer {
    FtpServerFactory serverFactory = new FtpServerFactory();
    ListenerFactory listenerFactory = new ListenerFactory();

    public static SimpleFtpServer create() {
        return new SimpleFtpServer();
    }

    public FtpServerFactory getServerFactory() {
        return this.serverFactory;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer setConnectionConfig(ConnectionConfig connectionConfig) {
        void var1_1;
        this.serverFactory.setConnectionConfig((ConnectionConfig)var1_1);
        return this;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer setPort(int port) {
        void var1_1;
        Assert.isTrue(NetUtil.isValidPort(port), "Invalid port!", new Object[0]);
        this.listenerFactory.setPort((int)var1_1);
        return this;
    }

    public UserManager getUserManager() {
        return this.serverFactory.getUserManager();
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer addUser(User user) {
        try {
            this.getUserManager().save(user);
        }
        catch (org.apache.ftpserver.ftplet.FtpException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer addAnonymous(String homePath) {
        void var2_2;
        void var1_1;
        BaseUser user = new BaseUser();
        user.setName("anonymous");
        user.setHomeDirectory(homePath);
        ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
        authorities.add(new WritePermission());
        user.setAuthorities((List)var1_1);
        return this.addUser((User)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer delUser(String userName) {
        try {
            this.getUserManager().delete(userName);
        }
        catch (org.apache.ftpserver.ftplet.FtpException e) {
            void var1_2;
            throw new FtpException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer setSsl(SslConfiguration ssl) {
        void var1_1;
        this.listenerFactory.setSslConfiguration((SslConfiguration)var1_1);
        this.listenerFactory.setImplicitSsl(true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer setSsl(File keystoreFile, String password) {
        void var3_3;
        void var2_2;
        void var1_1;
        SslConfigurationFactory sslFactory = new SslConfigurationFactory();
        sslFactory.setKeystoreFile((File)var1_1);
        sslFactory.setKeystorePassword((String)var2_2);
        return this.setSsl(var3_3.createSslConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer setUserManager(UserManager userManager) {
        void var1_1;
        this.serverFactory.setUserManager((UserManager)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer setUsersConfig(File propertiesFile) {
        void var2_2;
        void var1_1;
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        userManagerFactory.setFile((File)var1_1);
        return this.setUserManager(var2_2.createUserManager());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFtpServer addFtplet(String name, Ftplet ftplet) {
        void var2_2;
        void var1_1;
        this.serverFactory.getFtplets().put(var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        this.serverFactory.addListener("default", this.listenerFactory.createListener());
        try {
            this.serverFactory.createServer().start();
            return;
        }
        catch (org.apache.ftpserver.ftplet.FtpException e) {
            void var1_1;
            throw new FtpException((Throwable)var1_1);
        }
    }
}

