/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ftp.FtpMode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private FtpMode mode;
    private boolean backToPwd;

    /*
     * WARNING - void declaration
     */
    public Ftp(String host) {
        this((String)var1_1, 21);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(String host, int port) {
        this((String)var1_1, (int)var2_2, "anonymous", "");
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(String host, int port, String user, String password) {
        this((String)var1_1, (int)var2_2, (String)var3_3, password, CharsetUtil.CHARSET_UTF_8);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(String host, int port, String user, String password, Charset charset) {
        this((String)var1_1, (int)var2_2, (String)var3_3, password, charset, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(String host, int port, String user, String password, Charset charset, String serverLanguageCode, String systemKey) {
        this((String)var1_1, (int)var2_2, (String)var3_3, password, charset, serverLanguageCode, systemKey, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(String host, int port, String user, String password, Charset charset, String serverLanguageCode, String systemKey, FtpMode mode) {
        this(new FtpConfig((String)var1_1, (int)var2_2, (String)var3_3, password, charset, serverLanguageCode, systemKey), mode);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(FtpConfig config, FtpMode mode) {
        super((FtpConfig)var1_1);
        void var2_2;
        void var1_1;
        this.mode = var2_2;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public Ftp(FTPClient client) {
        super(FtpConfig.create());
        void var1_1;
        this.client = var1_1;
    }

    public Ftp init() {
        Ftp ftp = this;
        return ftp.init(ftp.ftpConfig, this.mode);
    }

    /*
     * WARNING - void declaration
     */
    public Ftp init(String host, int port, String user, String password) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.init((String)var1_1, (int)var2_2, (String)var3_3, password, null);
    }

    /*
     * WARNING - void declaration
     */
    public Ftp init(String host, int port, String user, String password, FtpMode mode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.init(new FtpConfig((String)var1_1, (int)var2_2, (String)var3_3, password, this.ftpConfig.getCharset(), null, null), mode);
    }

    /*
     * WARNING - void declaration
     */
    public Ftp init(FtpConfig config, FtpMode mode) {
        void var3_3;
        FTPClient client = new FTPClient();
        client.setRemoteVerificationEnabled(false);
        Charset charset = config.getCharset();
        if (charset != null) {
            client.setControlEncoding(charset.toString());
        }
        client.setConnectTimeout((int)config.getConnectionTimeout());
        String systemKey = config.getSystemKey();
        if (StrUtil.isNotBlank(systemKey)) {
            FTPClientConfig conf = new FTPClientConfig(systemKey);
            String string = config.getServerLanguageCode();
            if (StrUtil.isNotBlank(string)) {
                conf.setServerLanguageCode(config.getServerLanguageCode());
            }
            client.configure(conf);
        }
        try {
            client.connect(config.getHost(), config.getPort());
            client.setSoTimeout((int)config.getSoTimeout());
            client.login(config.getUser(), config.getPassword());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            void var1_1;
            try {
                client.disconnect();
            }
            catch (IOException iOException) {}
            throw new FtpException("Login failed for user [{}], reply code is: [{}]", var1_1.getUser(), replyCode);
        }
        this.client = var3_3;
        if (mode != null) {
            void var2_2;
            this.setMode((FtpMode)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp setMode(FtpMode mode) {
        void var1_1;
        this.mode = mode;
        switch (1.$SwitchMap$cn$hutool$extra$ftp$FtpMode[var1_1.ordinal()]) {
            case 1: {
                this.client.enterLocalActiveMode();
                break;
            }
            case 2: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Ftp setBackToPwd(boolean backToPwd) {
        void var1_1;
        this.backToPwd = var1_1;
        return this;
    }

    public boolean isBackToPwd() {
        return this.backToPwd;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Ftp reconnectIfTimeout() {
        void var1_1;
        String pwd = null;
        try {
            pwd = ((AbstractFtp)this).pwd();
        }
        catch (IORuntimeException iORuntimeException) {}
        if (var1_1 == null) {
            return this.init();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean cd(String directory) {
        if (StrUtil.isBlank(directory)) {
            return true;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> ls(String path) {
        void var1_1;
        return ArrayUtil.map(this.lsFiles((String)var1_1), FTPFile::getName);
    }

    /*
     * WARNING - void declaration
     */
    public List<FTPFile> lsFiles(String path, Filter<FTPFile> filter) {
        void var3_3;
        FTPFile[] ftpFiles = this.lsFiles(path);
        if (ArrayUtil.isEmpty(ftpFiles)) {
            return ListUtil.empty();
        }
        ArrayList<FTPFile> result = new ArrayList<FTPFile>(ftpFiles.length - 2 <= 0 ? ftpFiles.length : ftpFiles.length - 2);
        FTPFile[] fTPFileArray = ftpFiles;
        int n = ftpFiles.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            FTPFile ftpFile = fTPFileArray[i];
            String fileName = ftpFile.getName();
            if (StrUtil.equals(".", fileName) || StrUtil.equals("..", (CharSequence)var1_1) || filter != null && !filter.accept(ftpFile)) continue;
            result.add(ftpFile);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public FTPFile[] lsFiles(String path) throws FtpException, IORuntimeException {
        void var1_1;
        String pwd = null;
        if (StrUtil.isNotBlank(path)) {
            pwd = ((AbstractFtp)this).pwd();
            if (!((AbstractFtp)this).cd(path)) {
                throw new FtpException("Change dir to [{}] error, maybe path not exist!", path);
            }
        }
        try {
            FTPFile[] ftpFiles = this.client.listFiles();
            ((AbstractFtp)this).cd(pwd);
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable e2) {
                void ftpFiles;
                void var2_4;
                ((AbstractFtp)this).cd((String)var2_4);
                throw ftpFiles;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean mkdir(String dir) throws IORuntimeException {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int stat(String path) throws IORuntimeException {
        try {
            return this.client.stat(path);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean existFile(String path) throws IORuntimeException {
        void var1_1;
        try {
            FTPFile[] ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return ArrayUtil.isNotEmpty(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delFile(String path) throws IORuntimeException {
        void var1_2;
        String pwd = ((AbstractFtp)this).pwd();
        String fileName = FileUtil.getName(path);
        String dir = StrUtil.removeSuffix(path, fileName);
        if (!((AbstractFtp)this).cd(dir)) {
            throw new FtpException("Change dir to [{}] error, maybe dir not exist!", path);
        }
        try {
            void var3_6;
            boolean isSuccess = this.client.deleteFile((String)var3_6);
            ((AbstractFtp)this).cd(pwd);
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable e2) {
                void isSuccess;
                void var2_5;
                ((AbstractFtp)this).cd((String)var2_5);
                throw isSuccess;
            }
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delDir(String dirPath) throws IORuntimeException {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        FTPFile[] fTPFileArray = dirs;
        int n = dirs.length;
        for (int i = 0; i < n; ++i) {
            void var3_8;
            FTPFile ftpFile = fTPFileArray[i];
            String name = ftpFile.getName();
            String childPath = StrUtil.format("{}/{}", dirPath, name);
            if (ftpFile.isDirectory()) {
                void var2_2;
                if (".".equals(name) || "..".equals(var2_2)) continue;
                ((AbstractFtp)this).delDir(childPath);
                continue;
            }
            ((AbstractFtp)this).delFile((String)var3_8);
        }
        try {
            void var1_1;
            return this.client.removeDirectory((String)var1_1);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean upload(String destPath, File file) {
        void var2_2;
        void var1_1;
        Assert.notNull(file, "file to upload is null !", new Object[0]);
        return this.upload((String)var1_1, file.getName(), (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean upload(String destPath, String fileName, File file) throws IORuntimeException {
        boolean bl;
        block12: {
            Throwable throwable;
            BufferedInputStream in = FileUtil.getInputStream(file);
            Throwable throwable2 = null;
            try {
                void var2_4;
                bl = this.upload((String)((Object)throwable), (String)var2_4, in);
                if (in == null) break block12;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throwable2 = throwable3;
                        throw throwable;
                    }
                    catch (Throwable throwable4) {
                        if (in != null) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    void var3_7;
                    throw new IORuntimeException((Throwable)var3_7);
                }
            }
            ((InputStream)in).close();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean upload(String destPath2, String fileName, InputStream fileStream) throws IORuntimeException {
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = ((AbstractFtp)this).pwd();
        }
        if (StrUtil.isNotBlank(destPath2)) {
            this.mkDirs(destPath2);
            if (!((AbstractFtp)this).cd(destPath2)) {
                throw new FtpException("Change dir to [{}] error, maybe dir not exist!", destPath2);
            }
        }
        try {
            void var3_6;
            void var2_5;
            boolean destPath2 = this.client.storeFile((String)var2_5, (InputStream)var3_6);
            return destPath2;
        }
        catch (IOException e) {
            void var1_3;
            throw new IORuntimeException((Throwable)var1_3);
        }
        finally {
            if (this.backToPwd) {
                ((AbstractFtp)this).cd(pwd);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void uploadFileOrDirectory(String remotePath, File uploadFile) {
        void var3_3;
        Iterator iterator;
        if (!FileUtil.isDirectory(uploadFile)) {
            ((AbstractFtp)this).upload(remotePath, uploadFile);
            return;
        }
        File[] files = uploadFile.listFiles();
        if (ArrayUtil.isEmpty(files)) {
            return;
        }
        ArrayList<void> dirs = new ArrayList<void>(files.length);
        for (void f : iterator) {
            if (f.isDirectory()) {
                dirs.add(f);
                continue;
            }
            ((AbstractFtp)this).upload(remotePath, (File)f);
        }
        for (File f : var3_3) {
            String dir = FileUtil.normalize(remotePath + "/" + f.getName());
            this.uploadFileOrDirectory(dir, f);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void download(String path, File outFile) {
        void var2_2;
        void var3_3;
        void var1_1;
        String fileName = FileUtil.getName(path);
        String dir = StrUtil.removeSuffix(path, fileName);
        this.download((String)var1_1, (String)var3_3, (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        for (FTPFile ftpFile : this.lsFiles(sourcePath, null)) {
            void var3_4;
            String fileName = ftpFile.getName();
            String srcFile = StrUtil.format("{}/{}", sourcePath, fileName);
            File destFile = FileUtil.file(destDir, fileName);
            if (!ftpFile.isDirectory()) {
                if (FileUtil.exist(destFile) && ftpFile.getTimestamp().getTimeInMillis() <= destFile.lastModified()) continue;
                ((AbstractFtp)this).download(srcFile, destFile);
                continue;
            }
            FileUtil.mkdir(destFile);
            ((AbstractFtp)this).recursiveDownloadFolder(srcFile, (File)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void download(String path, String fileName, File outFile) throws IORuntimeException {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtil.touch(outFile);
        }
        try {
            BufferedOutputStream out;
            block14: {
                block13: {
                    Throwable throwable;
                    out = FileUtil.getOutputStream(outFile);
                    Throwable throwable2 = null;
                    try {
                        void var2_3;
                        this.download((String)((Object)throwable), (String)var2_3, out);
                        if (out == null) break block13;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throwable2 = throwable3;
                            throw throwable;
                        }
                        catch (Throwable throwable4) {
                            if (out != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)out).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((OutputStream)out).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    break block14;
                }
                return;
            }
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            void var3_6;
            throw new IORuntimeException((Throwable)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void download(String path, String fileName, OutputStream out) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.download((String)var1_1, (String)var2_2, (OutputStream)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void download(String path, String fileName, OutputStream out, Charset fileNameCharset) throws IORuntimeException {
        block8: {
            String pwd = null;
            if (this.backToPwd) {
                pwd = ((AbstractFtp)this).pwd();
            }
            if (!((AbstractFtp)this).cd(path)) {
                throw new FtpException("Change dir to [{}] error, maybe dir not exist!", path);
            }
            if (fileNameCharset != null) {
                fileName = new String(fileName.getBytes(fileNameCharset), StandardCharsets.ISO_8859_1);
            }
            try {
                void var3_5;
                void var2_4;
                this.client.setFileType(2);
                this.client.retrieveFile((String)var2_4, (OutputStream)var3_5);
                if (!this.backToPwd) break block8;
                ((AbstractFtp)this).cd(pwd);
            }
            catch (IOException e) {
                try {
                    void var1_2;
                    throw new IORuntimeException((Throwable)var1_2);
                }
                catch (Throwable throwable) {
                    if (this.backToPwd) {
                        ((AbstractFtp)this).cd(pwd);
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

