/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractFtp
implements Closeable {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    protected FtpConfig ftpConfig;

    /*
     * WARNING - void declaration
     */
    protected AbstractFtp(FtpConfig config) {
        void var1_1;
        this.ftpConfig = var1_1;
    }

    public abstract AbstractFtp reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    /*
     * WARNING - void declaration
     */
    public boolean isDir(String dir) {
        boolean bl;
        String workDir = this.pwd();
        try {
            void var1_1;
            bl = this.cd((String)var1_1);
            this.cd(workDir);
        }
        catch (Throwable throwable) {
            void var2_4;
            this.cd((String)var2_4);
            throw throwable;
        }
        return bl;
    }

    public abstract boolean mkdir(String var1);

    /*
     * WARNING - void declaration
     */
    public boolean exist(String path) {
        void var2_2;
        void var1_1;
        if (StrUtil.isBlank(path)) {
            return false;
        }
        if (this.isDir(path)) {
            return true;
        }
        String string = path;
        if (CharUtil.isFileSeparator(string.charAt(string.length() - 1))) {
            return false;
        }
        String fileName = FileUtil.getName(path);
        if (".".equals(fileName) || "..".equals(fileName)) {
            return false;
        }
        String dir = StrUtil.emptyToDefault(StrUtil.removeSuffix(path, fileName), ".");
        if (!this.isDir(dir)) {
            return false;
        }
        try {
            List<String> names = this.ls(dir);
        }
        catch (FtpException ftpException) {
            return false;
        }
        return AbstractFtp.containsIgnoreCase((List<String>)var1_1, (String)var2_2);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    /*
     * WARNING - void declaration
     */
    public void mkDirs(String dir) {
        void var2_2;
        void var1_1;
        String[] dirs = StrUtil.trim(dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StrUtil.isEmpty(dirs[0])) {
            this.cd("/");
        }
        for (void s : var1_1) {
            if (!StrUtil.isNotEmpty((CharSequence)s)) continue;
            boolean exist = true;
            try {
                if (!this.cd((String)s)) {
                    exist = false;
                }
            }
            catch (FtpException ftpException) {
                exist = false;
            }
            if (exist) continue;
            this.mkdir((String)s);
            this.cd((String)s);
        }
        this.cd((String)var2_2);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);

    /*
     * WARNING - void declaration
     */
    public void download(String path, File outFile, String tempFileSuffix) {
        void var3_4;
        tempFileSuffix = StrUtil.isBlank(tempFileSuffix) ? ".temp" : StrUtil.addPrefixIfNot(tempFileSuffix, ".");
        String fileName = outFile.isDirectory() ? FileUtil.getName(path) : outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.isDirectory() ? outFile : outFile.getParentFile(), (String)var3_4);
        try {
            this.download(path, outFile);
            FileUtil.rename(outFile, fileName, true);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            void var2_3;
            FileUtil.del((File)var2_3);
            throw new FtpException((Throwable)var1_2);
        }
    }

    public abstract void recursiveDownloadFolder(String var1, File var2);

    /*
     * WARNING - void declaration
     */
    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        Iterator<String> iterator;
        if (CollUtil.isEmpty(names)) {
            return false;
        }
        if (StrUtil.isEmpty(nameToFind)) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            String name = (String)iterator.next();
            if (!nameToFind.equalsIgnoreCase((String)var2_2)) continue;
            return true;
        }
        return false;
    }
}

