/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.extractor;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.compress.CompressException;
import cn.hutool.extra.compress.extractor.Extractor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class StreamExtractor
implements Extractor {
    private final ArchiveInputStream in;

    /*
     * WARNING - void declaration
     */
    public StreamExtractor(Charset charset, File file) {
        this((Charset)var1_1, null, (File)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamExtractor(Charset charset, String archiverName, File file) {
        this((Charset)var1_1, (String)var2_2, FileUtil.getInputStream((File)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamExtractor(Charset charset, InputStream in) {
        this((Charset)var1_1, null, (InputStream)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamExtractor(Charset charset, String archiverName, InputStream in) {
        block7: {
            if (in instanceof ArchiveInputStream) {
                this.in = (ArchiveInputStream)in;
                return;
            }
            ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
            try {
                void var2_4;
                void e2;
                in = IoUtil.toBuffered(in);
                if (StrUtil.isBlank(archiverName)) {
                    this.in = factory.createArchiveInputStream(in);
                    break block7;
                }
                if ("tgz".equalsIgnoreCase(archiverName) || "tar.gz".equalsIgnoreCase(archiverName)) {
                    try {
                        this.in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in));
                        break block7;
                    }
                    catch (IOException e2) {
                        throw new IORuntimeException(e2);
                    }
                }
                this.in = e2.createArchiveInputStream((String)var2_4, in);
                return;
            }
            catch (ArchiveException e) {
                void var1_3;
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                throw new CompressException((Throwable)var1_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extract(File targetDir, int stripComponents, Filter<ArchiveEntry> filter) {
        try {
            void var3_5;
            void var2_4;
            this.extractInternal(targetDir, (int)var2_4, (Filter<ArchiveEntry>)var3_5);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        finally {
            this.close();
        }
    }

    private void extractInternal(File targetDir, int stripComponents, Filter<ArchiveEntry> filter) throws IOException {
        ArchiveEntry entry;
        Assert.isTrue(targetDir != null && (false == targetDir.exists() || targetDir.isDirectory()), "target must be dir.", new Object[0]);
        ArchiveInputStream in = this.in;
        while (null != (entry = in.getNextEntry())) {
            String entryName;
            if (filter != null && !filter.accept(entry) || !in.canReadEntryData(entry) || (entryName = this.stripName(entry.getName(), stripComponents)) == null) continue;
            File outItemFile = FileUtil.file(targetDir, entryName);
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileUtil.writeFromStream((InputStream)in, outItemFile, false);
        }
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.in);
    }
}

