/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.extractor;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.compress.extractor.Extractor;
import cn.hutool.extra.compress.extractor.Seven7EntryInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.RandomAccess;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class SevenZExtractor
implements Extractor,
RandomAccess {
    private final SevenZFile sevenZFile;

    /*
     * WARNING - void declaration
     */
    public SevenZExtractor(File file) {
        this((File)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SevenZExtractor(File file, char[] password) {
        try {
            void var2_3;
            this.sevenZFile = new SevenZFile(file, (char[])var2_3);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SevenZExtractor(InputStream in) {
        this((InputStream)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SevenZExtractor(InputStream in, char[] password) {
        this((SeekableByteChannel)new SeekableInMemoryByteChannel(IoUtil.readBytes((InputStream)var1_1)), (char[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SevenZExtractor(SeekableByteChannel channel) {
        this((SeekableByteChannel)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SevenZExtractor(SeekableByteChannel channel, char[] password) {
        try {
            void var2_3;
            this.sevenZFile = new SevenZFile(channel, (char[])var2_3);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extract(File targetDir, int stripComponents, Filter<ArchiveEntry> filter) {
        try {
            void var3_5;
            void var2_4;
            this.extractInternal(targetDir, (int)var2_4, (Filter<ArchiveEntry>)var3_5);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getFirst(Filter<ArchiveEntry> filter) {
        SevenZFile sevenZFile = this.sevenZFile;
        for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
            if (filter != null && !filter.accept((ArchiveEntry)entry) || entry.isDirectory()) continue;
            try {
                void var2_3;
                return var2_3.getInputStream(entry);
            }
            catch (IOException e) {
                void var1_2;
                throw new IORuntimeException((Throwable)var1_2);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream get(String entryName) {
        void var1_1;
        return this.getFirst(arg_0 -> SevenZExtractor.lambda$get$0((String)var1_1, arg_0));
    }

    private void extractInternal(File targetDir, int stripComponents, Filter<ArchiveEntry> filter) throws IOException {
        SevenZArchiveEntry entry;
        Assert.isTrue(targetDir != null && (false == targetDir.exists() || targetDir.isDirectory()), "target must be dir.", new Object[0]);
        SevenZFile sevenZFile = this.sevenZFile;
        while (null != (entry = this.sevenZFile.getNextEntry())) {
            String entryName;
            if (filter != null && !filter.accept((ArchiveEntry)entry) || (entryName = this.stripName(entry.getName(), stripComponents)) == null) continue;
            File outItemFile = FileUtil.file(targetDir, entryName);
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            if (entry.hasStream()) {
                FileUtil.writeFromStream((InputStream)new Seven7EntryInputStream(sevenZFile, entry), outItemFile);
                continue;
            }
            FileUtil.touch(outItemFile);
        }
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.sevenZFile);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$get$0(String entryName, ArchiveEntry entry) {
        void var1_1;
        return StrUtil.equals(entryName, var1_1.getName());
    }
}

