/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.archiver;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.compress.CompressException;
import cn.hutool.extra.compress.archiver.Archiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class StreamArchiver
implements Archiver {
    private final ArchiveOutputStream out;

    /*
     * WARNING - void declaration
     */
    public static StreamArchiver create(Charset charset, String archiverName, File file) {
        void var2_2;
        void var1_1;
        Charset charset2;
        return new StreamArchiver(charset2, (String)var1_1, (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static StreamArchiver create(Charset charset, String archiverName, OutputStream out) {
        void var2_2;
        void var1_1;
        Charset charset2;
        return new StreamArchiver(charset2, (String)var1_1, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StreamArchiver(Charset charset, String archiverName, File file) {
        this((Charset)var1_1, (String)var2_2, FileUtil.getOutputStream((File)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StreamArchiver(Charset charset, String archiverName, OutputStream targetStream) {
        void e2;
        if ("tgz".equalsIgnoreCase(archiverName) || "tar.gz".equalsIgnoreCase(archiverName)) {
            try {
                this.out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(targetStream));
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
        }
        ArchiveStreamFactory factory = new ArchiveStreamFactory(e2.name());
        try {
            void var3_5;
            void var2_4;
            this.out = factory.createArchiveOutputStream((String)var2_4, (OutputStream)var3_5);
        }
        catch (ArchiveException e2) {
            void var1_3;
            throw new CompressException((Throwable)var1_3);
        }
        if (this.out instanceof TarArchiveOutputStream) {
            ((TarArchiveOutputStream)this.out).setLongFileMode(2);
            return;
        }
        if (this.out instanceof ArArchiveOutputStream) {
            ((ArArchiveOutputStream)this.out).setLongFileMode(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StreamArchiver add(File file, String path, Filter<File> filter) throws IORuntimeException {
        try {
            void var3_4;
            void var2_3;
            this.addInternal(file, (String)var2_3, (Filter<File>)var3_4);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StreamArchiver finish() {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {}
        IoUtil.close((Closeable)this.out);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void addInternal(File file, String path, Filter<File> filter) throws IOException {
        void var1_1;
        if (filter != null && !filter.accept(file)) {
            return;
        }
        ArchiveOutputStream out = this.out;
        String entryName = StrUtil.isNotEmpty(path) ? StrUtil.addSuffixIfNot(path, "/") + file.getName() : file.getName();
        ArchiveOutputStream archiveOutputStream = out;
        archiveOutputStream.putArchiveEntry(archiveOutputStream.createArchiveEntry(file, entryName));
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (!ArrayUtil.isNotEmpty(files)) {
                out.closeArchiveEntry();
                return;
            }
            for (void childFile : var1_1) {
                this.addInternal((File)childFile, entryName, filter);
            }
            return;
        } else {
            if (var1_1.isFile()) {
                FileUtil.writeToStream((File)var1_1, (OutputStream)out);
            }
            out.closeArchiveEntry();
        }
    }
}

