/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.archiver;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.compress.archiver.Archiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class SevenZArchiver
implements Archiver {
    private final SevenZOutputFile sevenZOutputFile;
    private SeekableByteChannel channel;
    private OutputStream out;

    /*
     * WARNING - void declaration
     */
    public SevenZArchiver(File file) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(file);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SevenZArchiver(OutputStream out) {
        this.out = out;
        this.channel = new SeekableInMemoryByteChannel();
        try {
            this.sevenZOutputFile = new SevenZOutputFile(this.channel);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SevenZArchiver(SeekableByteChannel channel) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(channel);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    public SevenZOutputFile getSevenZOutputFile() {
        return this.sevenZOutputFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SevenZArchiver add(File file, String path, Filter<File> filter) {
        try {
            void var3_4;
            void var2_3;
            this.addInternal(file, (String)var2_3, (Filter<File>)var3_4);
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SevenZArchiver finish() {
        try {
            this.sevenZOutputFile.finish();
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {}
        if (this.out != null && this.channel instanceof SeekableInMemoryByteChannel) {
            try {
                this.out.write(((SeekableInMemoryByteChannel)this.channel).array());
            }
            catch (IOException e) {
                void var1_1;
                throw new IORuntimeException((Throwable)var1_1);
            }
        }
        IoUtil.close((Closeable)this.sevenZOutputFile);
    }

    /*
     * WARNING - void declaration
     */
    private void addInternal(File file, String path, Filter<File> filter) throws IOException {
        void var1_1;
        if (filter != null && !filter.accept(file)) {
            return;
        }
        SevenZOutputFile out = this.sevenZOutputFile;
        String entryName = StrUtil.isNotEmpty(path) ? StrUtil.addSuffixIfNot(path, "/") + file.getName() : file.getName();
        SevenZOutputFile sevenZOutputFile = out;
        sevenZOutputFile.putArchiveEntry(sevenZOutputFile.createArchiveEntry(file, entryName));
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtil.isNotEmpty(files)) {
                for (void childFile : var1_1) {
                    this.addInternal((File)childFile, entryName, filter);
                }
            }
            return;
        }
        if (var1_1.isFile()) {
            out.write(FileUtil.readBytes((File)var1_1));
        }
        out.closeArchiveEntry();
    }
}

