/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.compress.CompressException;
import cn.hutool.extra.compress.archiver.Archiver;
import cn.hutool.extra.compress.archiver.SevenZArchiver;
import cn.hutool.extra.compress.archiver.StreamArchiver;
import cn.hutool.extra.compress.extractor.Extractor;
import cn.hutool.extra.compress.extractor.SevenZExtractor;
import cn.hutool.extra.compress.extractor.StreamExtractor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class CompressUtil {
    /*
     * WARNING - void declaration
     */
    public static CompressorOutputStream getOut(String compressorName, OutputStream out) {
        try {
            void var1_2;
            return new CompressorStreamFactory().createCompressorOutputStream(compressorName, (OutputStream)var1_2);
        }
        catch (CompressorException e) {
            void var0_1;
            throw new CompressException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static CompressorInputStream getIn(String compressorName, InputStream in) {
        in = IoUtil.toMarkSupportStream(in);
        try {
            void var1_2;
            if (StrUtil.isBlank(compressorName)) {
                compressorName = CompressorStreamFactory.detect((InputStream)in);
            }
            return new CompressorStreamFactory().createCompressorInputStream(compressorName, (InputStream)var1_2);
        }
        catch (CompressorException e) {
            void var0_1;
            throw new CompressException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Archiver createArchiver(Charset charset, String archiverName, File file) {
        void var2_2;
        void var1_1;
        Charset charset2;
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZArchiver(file);
        }
        return StreamArchiver.create(charset2, (String)var1_1, (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Archiver createArchiver(Charset charset, String archiverName, OutputStream out) {
        void var2_2;
        void var1_1;
        Charset charset2;
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZArchiver(out);
        }
        return StreamArchiver.create(charset2, (String)var1_1, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Extractor createExtractor(Charset charset, File file) {
        void var1_1;
        return CompressUtil.createExtractor(charset, null, (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Extractor createExtractor(Charset charset, String archiverName, File file) {
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZExtractor(file);
        }
        try {
            return new StreamExtractor(charset, archiverName, file);
        }
        catch (CompressException compressException) {
            CompressException compressException2;
            void var1_1;
            CompressException e = compressException;
            Throwable cause = compressException.getCause();
            if (cause instanceof StreamingNotSupportedException && var1_1.getMessage().contains("7z")) {
                void var2_2;
                return new SevenZExtractor((File)var2_2);
            }
            throw compressException2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Extractor createExtractor(Charset charset, InputStream in) {
        void var1_1;
        return CompressUtil.createExtractor(charset, null, (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Extractor createExtractor(Charset charset, String archiverName, InputStream in) {
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZExtractor(in);
        }
        try {
            return new StreamExtractor(charset, archiverName, in);
        }
        catch (CompressException compressException) {
            CompressException compressException2;
            void var1_1;
            CompressException e = compressException;
            Throwable cause = compressException.getCause();
            if (cause instanceof StreamingNotSupportedException && var1_1.getMessage().contains("7z")) {
                void var2_2;
                return new SevenZExtractor((InputStream)var2_2);
            }
            throw compressException2;
        }
    }
}

