/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.dfa;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.FoundWord;
import cn.hutool.dfa.StopChar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WordTree
extends HashMap<Character, WordTree> {
    private static final long serialVersionUID = -4646423269465809276L;
    private final Set<Character> endCharacterSet = new HashSet<Character>();
    private Filter<Character> charFilter = StopChar::isNotStopChar;

    /*
     * WARNING - void declaration
     */
    public WordTree setCharFilter(Filter<Character> charFilter) {
        void var1_1;
        this.charFilter = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public WordTree addWords(Collection<String> words) {
        Iterator iterator;
        if (!(words instanceof Set)) {
            words = new HashSet<String>(words);
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            String word = (String)iterator.next();
            this.addWord((String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public WordTree addWords(String ... words) {
        for (String word : CollUtil.newHashSet(words)) {
            void var2_2;
            this.addWord((String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public WordTree addWord(String word) {
        Filter<Character> charFilter = this.charFilter;
        WordTree parent = null;
        WordTree current = this;
        char currentChar = '\u0000';
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            currentChar = word.charAt(i);
            if (!charFilter.accept(Character.valueOf(currentChar))) continue;
            WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
            if (child == null) {
                child = new WordTree();
                current.put(Character.valueOf(currentChar), child);
            }
            parent = current;
            current = child;
        }
        if (parent != null) {
            void var3_3;
            super.setEnd(Character.valueOf(currentChar));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMatch(String text) {
        void var1_1;
        if (text == null) {
            return false;
        }
        return null != this.matchWord((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String match(String text) {
        FoundWord foundWord = this.matchWord(text);
        if (foundWord != null) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    public FoundWord matchWord(String text) {
        List<FoundWord> list;
        if (text == null) {
            return null;
        }
        list = this.matchAllWords((String)((Object)list), 1);
        return CollUtil.get(list, 0);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> matchAll(String text) {
        void var1_1;
        return this.matchAll((String)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public List<FoundWord> matchAllWords(String text) {
        void var1_1;
        return this.matchAllWords((String)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> matchAll(String text, int limit) {
        void var2_2;
        void var1_1;
        return this.matchAll((String)var1_1, (int)var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public List<FoundWord> matchAllWords(String text, int limit) {
        void var2_2;
        void var1_1;
        return this.matchAllWords((String)var1_1, (int)var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> matchAll(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        void var3_3;
        void var2_2;
        List<FoundWord> list;
        list = this.matchAllWords((String)((Object)list), (int)var2_2, (boolean)var3_3, isGreedMatch);
        return CollUtil.map(list, FoundWord::toString, true);
    }

    public List<FoundWord> matchAllWords(String text, int limit, boolean isDensityMatch, boolean isGreedMatch) {
        if (text == null) {
            return null;
        }
        ArrayList<FoundWord> foundWords = new ArrayList<FoundWord>();
        WordTree current = this;
        int length = text.length();
        Filter<Character> charFilter = this.charFilter;
        StringBuilder wordBuffer = StrUtil.builder();
        StringBuilder keyBuffer = StrUtil.builder();
        for (int i = 0; i < length; ++i) {
            wordBuffer.setLength(0);
            keyBuffer.setLength(0);
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (!charFilter.accept(Character.valueOf(currentChar))) {
                    if (wordBuffer.length() > 0) {
                        wordBuffer.append(currentChar);
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                wordBuffer.append(currentChar);
                keyBuffer.append(currentChar);
                if (current.isEnd(Character.valueOf(currentChar))) {
                    foundWords.add(new FoundWord(keyBuffer.toString(), wordBuffer.toString(), i, j));
                    if (limit > 0 && foundWords.size() >= limit) {
                        return foundWords;
                    }
                    if (!isDensityMatch) {
                        i = j;
                        break;
                    }
                    if (!isGreedMatch) break;
                }
                if ((current = (WordTree)current.get(Character.valueOf(currentChar))) == null) break;
            }
            current = this;
        }
        return foundWords;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isEnd(Character c) {
        void var1_1;
        return this.endCharacterSet.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setEnd(Character c) {
        if (c != null) {
            void var1_1;
            this.endCharacterSet.add((Character)var1_1);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.endCharacterSet.clear();
    }
}

