/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.dfa;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.FoundWord;
import cn.hutool.dfa.SensitiveProcessor;
import cn.hutool.dfa.WordTree;
import cn.hutool.json.JSONUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class SensitiveUtil {
    public static final char DEFAULT_SEPARATOR = ',';
    private static final WordTree sensitiveTree = new WordTree();

    public static boolean isInited() {
        return false == sensitiveTree.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        Collection<String> collection;
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                SensitiveUtil.init(sensitiveWords);
                return Boolean.TRUE;
            });
            return;
        }
        SensitiveUtil.init(collection);
    }

    public static void init(Collection<String> sensitiveWords) {
        Collection<String> collection;
        sensitiveTree.clear();
        sensitiveTree.addWords(collection);
    }

    /*
     * WARNING - void declaration
     */
    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StrUtil.isNotBlank(sensitiveWords)) {
            void var2_2;
            void var1_1;
            String string;
            SensitiveUtil.init(StrUtil.split((CharSequence)string, (char)var1_1), (boolean)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void init(String sensitiveWords, boolean isAsync) {
        void var1_1;
        SensitiveUtil.init(sensitiveWords, ',', (boolean)var1_1);
    }

    public static void setCharFilter(Filter<Character> charFilter) {
        if (charFilter != null) {
            Filter<Character> filter;
            sensitiveTree.setCharFilter(filter);
        }
    }

    public static boolean containsSensitive(String text) {
        String string;
        return sensitiveTree.isMatch(string);
    }

    public static boolean containsSensitive(Object obj) {
        Object object;
        return sensitiveTree.isMatch(JSONUtil.toJsonStr(object));
    }

    public static FoundWord getFoundFirstSensitive(String text) {
        String string;
        return sensitiveTree.matchWord(string);
    }

    public static FoundWord getFoundFirstSensitive(Object obj) {
        Object object;
        return sensitiveTree.matchWord(JSONUtil.toJsonStr(object));
    }

    public static List<FoundWord> getFoundAllSensitive(String text) {
        String string;
        return sensitiveTree.matchAllWords(string);
    }

    /*
     * WARNING - void declaration
     */
    public static List<FoundWord> getFoundAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        void var2_2;
        void var1_1;
        String string;
        return sensitiveTree.matchAllWords(string, -1, (boolean)var1_1, (boolean)var2_2);
    }

    public static List<FoundWord> getFoundAllSensitive(Object bean) {
        Object object;
        return sensitiveTree.matchAllWords(JSONUtil.toJsonStr(object));
    }

    /*
     * WARNING - void declaration
     */
    public static List<FoundWord> getFoundAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        void var2_2;
        void var1_1;
        return SensitiveUtil.getFoundAllSensitive(JSONUtil.toJsonStr(bean), (boolean)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T sensitiveFilter(T bean, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        Object object;
        void var2_2;
        void var1_1;
        void var3_3;
        String jsonText = JSONUtil.toJsonStr(bean);
        Object c = bean.getClass();
        return JSONUtil.toBean(SensitiveUtil.sensitiveFilter((String)var3_3, (boolean)var1_1, (SensitiveProcessor)var2_2), object);
    }

    public static String sensitiveFilter(String text) {
        return SensitiveUtil.sensitiveFilter(text, true, null);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (StrUtil.isEmpty(text)) {
            return text;
        }
        List<FoundWord> foundWordList = SensitiveUtil.getFoundAllSensitive(text, true, isGreedMatch);
        if (CollUtil.isEmpty(foundWordList)) {
            return text;
        }
        sensitiveProcessor = sensitiveProcessor == null ? new SensitiveProcessor(){} : sensitiveProcessor;
        HashMap foundWordMap = new HashMap(foundWordList.size(), 1.0f);
        foundWordList.forEach(foundWord -> {
            void var1_1;
            FoundWord cfr_ignored_0 = (FoundWord)foundWordMap.put(foundWord.getStartIndex(), var1_1);
        });
        int length = text.length();
        StringBuilder textStringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            FoundWord fw = (FoundWord)foundWordMap.get(i);
            if (fw != null) {
                textStringBuilder.append(sensitiveProcessor.process(fw));
                i = (Integer)fw.getEndIndex();
                continue;
            }
            textStringBuilder.append(text.charAt(i));
        }
        return textStringBuilder.toString();
    }
}

