/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.SqlFormatter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    /*
     * WARNING - void declaration
     */
    public static String buildEqualsWhere(Entity entity, List<Object> paramValues) {
        void var2_2;
        Object object;
        if (entity == null || entity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        boolean isNotFirst = false;
        for (Map.Entry entry : ((LinkedHashMap)object).entrySet()) {
            if (isNotFirst) {
                sb.append(" and ");
            } else {
                isNotFirst = true;
            }
            sb.append("`").append((String)entry.getKey()).append("` = ?");
            paramValues.add(entry.getValue());
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Condition[] buildConditions(Entity entity) {
        void var1_1;
        if (entity == null || entity.isEmpty()) {
            return null;
        }
        Condition[] conditions = new Condition[entity.size()];
        int i = 0;
        for (Map.Entry entry : entity.entrySet()) {
            Entity entity2;
            Entity value = entry.getValue();
            if (value instanceof Condition) {
                conditions[i++] = (Condition)((Object)value);
                continue;
            }
            conditions[i++] = new Condition((String)entry.getKey(), entity2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildLikeValue(String value, Condition.LikeType likeType, boolean withLikeKeyword) {
        void var2_3;
        void var1_1;
        if (value == null) {
            return null;
        }
        StringBuilder likeValue = StrUtil.builder(withLikeKeyword ? "LIKE " : "");
        switch (1.$SwitchMap$cn$hutool$db$sql$Condition$LikeType[var1_1.ordinal()]) {
            case 1: {
                likeValue.append(value).append('%');
                break;
            }
            case 2: {
                likeValue.append('%').append(value);
                break;
            }
            case 3: {
                String string;
                likeValue.append('%').append(string).append('%');
            }
        }
        return var2_3.toString();
    }

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static String rowIdToString(RowId rowId) {
        return StrUtil.str(rowId.getBytes(), CharsetUtil.CHARSET_ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            clob = IoUtil.read(reader);
        }
        catch (SQLException e) {
            try {
                void var0_1;
                throw new DbRuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                IoUtil.close((Closeable)var1_3);
                throw throwable;
            }
        }
        IoUtil.close(reader);
        return clob;
    }

    /*
     * WARNING - void declaration
     */
    public static String blobToStr(Blob blob, Charset charset) {
        InputStream in = null;
        try {
            void var1_3;
            in = blob.getBinaryStream();
            blob = IoUtil.read(in, (Charset)var1_3);
        }
        catch (SQLException e) {
            try {
                void var0_1;
                throw new DbRuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var2_4;
                IoUtil.close((Closeable)var2_4);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return blob;
    }

    /*
     * WARNING - void declaration
     */
    public static Blob createBlob(Connection conn, InputStream dataStream, boolean closeAfterUse) {
        Blob blob;
        OutputStream out = null;
        try {
            Blob blob2 = conn.createBlob();
            out = blob2.setBinaryStream(1L);
            IoUtil.copy(dataStream, out);
        }
        catch (SQLException e2) {
            try {
                throw new DbRuntimeException(e2);
            }
            catch (Throwable e2) {
                void blob3;
                void var2_4;
                void var3_5;
                IoUtil.close((Closeable)var3_5);
                if (var2_4 != false) {
                    void var1_3;
                    IoUtil.close((Closeable)var1_3);
                }
                throw blob3;
            }
        }
        IoUtil.close(out);
        if (closeAfterUse) {
            IoUtil.close(dataStream);
        }
        return blob;
    }

    /*
     * WARNING - void declaration
     */
    public static Blob createBlob(Connection conn, byte[] data) {
        Blob blob;
        try {
            void var1_2;
            Blob blob2 = conn.createBlob();
            blob2.setBytes(0L, (byte[])var1_2);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return blob;
    }

    public static Date toSqlDate(java.util.Date date) {
        java.util.Date date2;
        return new Date(date2.getTime());
    }

    public static Timestamp toSqlTimestamp(java.util.Date date) {
        java.util.Date date2;
        return new Timestamp(date2.getTime());
    }
}

