/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.db.DbUtil;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.NamedSql;
import cn.hutool.db.sql.SqlBuilder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class SqlExecutor {
    /*
     * WARNING - void declaration
     */
    public static int execute(Connection conn, String sql, Map<String, Object> paramMap) throws SQLException {
        void var1_1;
        Connection connection;
        void var2_2;
        NamedSql namedSql = new NamedSql(sql, (Map<String, Object>)var2_2);
        return SqlExecutor.execute(connection, namedSql.getSql(), var1_1.getParams());
    }

    /*
     * WARNING - void declaration
     */
    public static int execute(Connection conn, String sql, Object ... params) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            void var2_4;
            void var1_3;
            Connection connection;
            ps = StatementUtil.prepareStatement(false, connection, (String)var1_3, (Object[])var2_4);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            void var3_5;
            DbUtil.close(var3_5);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean call(Connection conn, String sql, Object ... params) throws SQLException {
        boolean bl;
        CallableStatement call = null;
        try {
            void var2_4;
            void var1_3;
            Connection connection;
            call = StatementUtil.prepareCall(connection, (String)var1_3, (Object[])var2_4);
            bl = call.execute();
        }
        catch (Throwable throwable) {
            void var3_5;
            DbUtil.close(var3_5);
            throw throwable;
        }
        DbUtil.close(call);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static ResultSet callQuery(Connection conn, String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        return StatementUtil.prepareCall(conn, (String)var1_1, (Object[])var2_2).executeQuery();
    }

    /*
     * WARNING - void declaration
     */
    public static Long executeForGeneratedKey(Connection conn, String sql, Map<String, Object> paramMap) throws SQLException {
        void var1_1;
        Connection connection;
        void var2_2;
        NamedSql namedSql = new NamedSql(sql, (Map<String, Object>)var2_2);
        return SqlExecutor.executeForGeneratedKey(connection, namedSql.getSql(), var1_1.getParams());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long executeForGeneratedKey(Connection conn, String sql, Object ... params) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            Long l;
            block5: {
                ps = null;
                rs = null;
                try {
                    void var2_3;
                    void var1_2;
                    ps = StatementUtil.prepareStatement(true, (Connection)((Object)l), (String)var1_2, (Object[])var2_3);
                    ps.executeUpdate();
                    rs = ps.getGeneratedKeys();
                    if (rs == null || !rs.next()) break block4;
                    try {
                        l = rs.getLong(1);
                        break block5;
                    }
                    catch (SQLException sQLException) {}
                    break block4;
                }
                catch (Throwable throwable) {
                    void var3_4;
                    DbUtil.close(var3_4);
                    DbUtil.close(rs);
                    throw throwable;
                }
            }
            DbUtil.close(ps);
            DbUtil.close(rs);
            return l;
        }
        DbUtil.close(ps);
        DbUtil.close(rs);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int[] executeBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        void var2_2;
        void var1_1;
        return SqlExecutor.executeBatch(conn, (String)var1_1, new ArrayIter<Object[]>((E[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] executeBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        Object object;
        PreparedStatement ps = null;
        try {
            void var2_3;
            void var1_2;
            ps = StatementUtil.prepareStatementForBatch((Connection)object, (String)var1_2, (Iterable<Object[]>)var2_3);
            object = ps.executeBatch();
        }
        catch (Throwable throwable) {
            void var3_4;
            DbUtil.close(var3_4);
            throw throwable;
        }
        DbUtil.close(ps);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] executeBatch(Connection conn, String ... sqls) throws SQLException {
        void var1_1;
        return SqlExecutor.executeBatch(conn, new ArrayIter<String>((E[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] executeBatch(Connection conn, Iterable<String> sqls) throws SQLException {
        Object object;
        Statement statement = null;
        try {
            statement = object.createStatement();
            for (String sql : sqls) {
                void var1_2;
                statement.addBatch((String)var1_2);
            }
            object = statement.executeBatch();
        }
        catch (Throwable throwable) {
            void var2_3;
            DbUtil.close(var2_3);
            throw throwable;
        }
        DbUtil.close(statement);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws SQLException {
        void var1_1;
        void var2_2;
        Connection connection;
        void var3_3;
        NamedSql namedSql = new NamedSql(sql, (Map<String, Object>)var3_3);
        return SqlExecutor.query(connection, namedSql.getSql(), var2_2, var1_1.getParams());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T query(Connection conn, SqlBuilder sqlBuilder, RsHandler<T> rsh) throws SQLException {
        void var1_1;
        void var2_2;
        return SqlExecutor.query(conn, sqlBuilder.build(), var2_2, var1_1.getParamValueArray());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection connection;
        PreparedStatement ps = null;
        try {
            void var2_3;
            void var3_4;
            void var1_2;
            ps = StatementUtil.prepareStatement(false, connection, (String)var1_2, (Object[])var3_4);
            connection = SqlExecutor.executeQuery(ps, var2_3);
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return (T)connection;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T query(Connection conn, Func1<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws SQLException {
        PreparedStatement ps = null;
        try {
            void var2_3;
            void var1_2;
            ps = (PreparedStatement)var1_2.call(conn);
            conn = SqlExecutor.executeQuery(ps, var2_3);
        }
        catch (Exception exception) {
            try {
                Exception exception2;
                Exception e = exception;
                if (exception instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw ExceptionUtil.wrapRuntime(exception2);
            }
            catch (Throwable throwable) {
                void var3_4;
                DbUtil.close(var3_4);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return (T)conn;
    }

    /*
     * WARNING - void declaration
     */
    public static int executeUpdate(PreparedStatement ps, Object ... params) throws SQLException {
        PreparedStatement preparedStatement;
        void var1_1;
        StatementUtil.fillParams(ps, (Object[])var1_1);
        return preparedStatement.executeUpdate();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean execute(PreparedStatement ps, Object ... params) throws SQLException {
        PreparedStatement preparedStatement;
        void var1_1;
        StatementUtil.fillParams(ps, (Object[])var1_1);
        return preparedStatement.execute();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T query(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws SQLException {
        void var1_1;
        PreparedStatement preparedStatement;
        void var2_2;
        StatementUtil.fillParams(ps, (Object[])var2_2);
        return SqlExecutor.executeQuery(preparedStatement, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T queryAndClosePs(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t;
        try {
            void var2_3;
            t = SqlExecutor.query(ps, t, (Object[])var2_3);
        }
        catch (Throwable throwable) {
            PreparedStatement preparedStatement;
            DbUtil.close(preparedStatement);
            throw throwable;
        }
        DbUtil.close(ps);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T executeQuery(PreparedStatement ps, RsHandler<T> rsh) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet rs = null;
        try {
            void var1_2;
            rs = preparedStatement.executeQuery();
            preparedStatement = var1_2.handle(rs);
        }
        catch (Throwable throwable) {
            void var2_3;
            DbUtil.close(var2_3);
            throw throwable;
        }
        DbUtil.close(rs);
        return (T)preparedStatement;
    }
}

