/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.dialect.impl.OracleDialect;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.ConditionBuilder;
import cn.hutool.db.sql.Direction;
import cn.hutool.db.sql.Order;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlFormatter;
import cn.hutool.db.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SqlBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> paramValues = new ArrayList<Object>();
    private Wrapper wrapper;

    public static SqlBuilder create() {
        return new SqlBuilder();
    }

    public static SqlBuilder create(Wrapper wrapper) {
        Wrapper wrapper2;
        return new SqlBuilder(wrapper2);
    }

    public static SqlBuilder of(CharSequence sql) {
        CharSequence charSequence;
        return SqlBuilder.create().append(charSequence);
    }

    public static void validateEntity(Entity entity) throws DbRuntimeException {
        Entity entity2;
        if (entity == null) {
            throw new DbRuntimeException("Entity is null !");
        }
        if (StrUtil.isBlank(entity.getTableName())) {
            throw new DbRuntimeException("Entity`s table name is null !");
        }
        if (entity2.isEmpty()) {
            throw new DbRuntimeException("No filed and value in this entity !");
        }
    }

    public SqlBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder(Wrapper wrapper) {
        void var1_1;
        this.wrapper = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder insert(Entity entity) {
        void var1_1;
        return this.insert((Entity)var1_1, DialectName.ANSI);
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder insert(Entity entity, DialectName dialectName) {
        void var2_2;
        void var1_1;
        return this.insert((Entity)var1_1, var2_2.name());
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder insert(Entity entity, String dialectName) {
        void var1_1;
        void var2_2;
        void var3_3;
        SqlBuilder.validateEntity(entity);
        boolean isOracle = DialectName.ORACLE.match(dialectName);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        entity.forEach((arg_0, arg_1) -> this.lambda$insert$0(fieldsPart, placeHolder, (boolean)var3_3, arg_0, arg_1));
        if (DialectName.PHOENIX.match((String)var2_2)) {
            this.sql.append("UPSERT INTO ");
        } else {
            this.sql.append("INSERT INTO ");
        }
        String tableName = entity.getTableName();
        if (this.wrapper != null) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append((String)var1_1).append(" (").append((CharSequence)fieldsPart).append(") VALUES (").append((CharSequence)placeHolder).append(")");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder delete(String tableName) {
        void var1_1;
        if (StrUtil.isBlank(tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (this.wrapper != null) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append("DELETE FROM ").append((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder update(Entity entity) {
        void var1_1;
        void var2_2;
        SqlBuilder.validateEntity(entity);
        String tableName = entity.getTableName();
        if (this.wrapper != null) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append("UPDATE ").append((String)var2_2).append(" SET ");
        var1_1.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field)) {
                void var2_2;
                void var1_1;
                if (this.paramValues.size() > 0) {
                    this.sql.append(", ");
                }
                this.sql.append((String)(this.wrapper != null ? this.wrapper.wrap((String)field) : var1_1)).append(" = ? ");
                this.paramValues.add(var2_2);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder select(boolean isDistinct, String ... fields) {
        void var2_2;
        void var1_1;
        return this.select((boolean)var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        void var1_1;
        this.sql.append("SELECT ");
        if (var1_1 != false) {
            this.sql.append("DISTINCT ");
        }
        if (CollectionUtil.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            void var2_2;
            if (this.wrapper != null) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(CollectionUtil.join(var2_2, (CharSequence)","));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder select(String ... fields) {
        void var1_1;
        return this.select(false, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder select(Collection<String> fields) {
        void var1_1;
        return this.select(false, (Collection<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder from(String ... tableNames) {
        void var1_1;
        if (ArrayUtil.isEmpty(tableNames) || StrUtil.hasBlank(tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (this.wrapper != null) {
            tableNames = this.wrapper.wrap(tableNames);
        }
        this.sql.append(" FROM ").append(ArrayUtil.join(var1_1, (CharSequence)","));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder where(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty(conditions)) {
            void var1_1;
            SqlBuilder sqlBuilder = this;
            sqlBuilder.where(sqlBuilder.buildCondition((Condition[])var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder where(String where) {
        if (StrUtil.isNotBlank(where)) {
            void var1_1;
            this.sql.append(" WHERE ").append((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <T> SqlBuilder in(String field, T ... values) {
        void var2_2;
        void var1_1;
        this.sql.append(this.wrapper.wrap((String)var1_1)).append(" IN (").append(ArrayUtil.join(var2_2, (CharSequence)",")).append(")");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder groupBy(String ... fields) {
        if (ArrayUtil.isNotEmpty(fields)) {
            void var1_1;
            if (this.wrapper != null) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(ArrayUtil.join(var1_1, (CharSequence)","));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder having(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty(conditions)) {
            void var1_1;
            SqlBuilder sqlBuilder = this;
            sqlBuilder.having(sqlBuilder.buildCondition((Condition[])var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder having(String having) {
        if (StrUtil.isNotBlank(having)) {
            void var1_1;
            this.sql.append(" HAVING ").append((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder orderBy(Order ... orders) {
        if (ArrayUtil.isEmpty(orders)) {
            return this;
        }
        this.sql.append(" ORDER BY ");
        boolean isFirst = true;
        Order[] orderArray = orders;
        int n = orders.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            Order order = orderArray[i];
            String field = order.getField();
            if (this.wrapper != null) {
                field = this.wrapper.wrap(field);
            }
            if (StrUtil.isBlank(field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(field);
            Direction direction = order.getDirection();
            if (direction == null) continue;
            this.sql.append(" ").append(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder join(String tableName, Join join) {
        if (StrUtil.isBlank(tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (join != null) {
            void var1_1;
            void var2_2;
            this.sql.append(" ").append(var2_2).append(" JOIN ");
            if (this.wrapper != null) {
                tableName = this.wrapper.wrap(tableName);
            }
            this.sql.append((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder on(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty(conditions)) {
            void var1_1;
            SqlBuilder sqlBuilder = this;
            sqlBuilder.on(sqlBuilder.buildCondition((Condition[])var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder on(String on) {
        if (StrUtil.isNotBlank(on)) {
            void var1_1;
            this.sql.append(" ON ").append((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder insertPreFragment(Object sqlFragment) {
        if (sqlFragment != null) {
            void var1_1;
            this.sql.insert(0, var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder append(Object sqlFragment) {
        if (sqlFragment != null) {
            void var1_1;
            this.sql.append(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder addParams(Object ... params) {
        if (ArrayUtil.isNotEmpty(params)) {
            void var1_1;
            Collections.addAll(this.paramValues, var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SqlBuilder query(Query query) {
        void var1_1;
        return this.select(query.getFields()).from(query.getTableNames()).where(var1_1.getWhere());
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[0]);
    }

    @Override
    public String build() {
        return this.sql.toString();
    }

    public String toString() {
        return this.build();
    }

    public SqlBuilder format() {
        this.sql.replace(0, this.sql.length(), SqlFormatter.format(this.sql.toString()));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String buildCondition(Condition ... conditions) {
        void var1_1;
        if (ArrayUtil.isEmpty(conditions)) {
            return "";
        }
        if (this.wrapper != null) {
            conditions = this.wrapper.wrap(conditions);
        }
        return ConditionBuilder.of((Condition[])var1_1).build(this.paramValues);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$insert$0(StringBuilder fieldsPart, StringBuilder placeHolder, boolean isOracle, String field, Object value) {
        if (StrUtil.isNotBlank(field)) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            var1_1.append(this.wrapper != null ? this.wrapper.wrap(field) : field);
            if (var3_3 != false && OracleDialect.isNextVal(value)) {
                placeHolder.append(value);
                return;
            }
            var2_2.append("?");
            this.paramValues.add(value);
        }
    }

    public static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

