/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedSql {
    private static final char[] NAME_START_CHARS = new char[]{':', '@', '?'};
    private String sql;
    private final List<Object> params = new LinkedList<Object>();

    /*
     * WARNING - void declaration
     */
    public NamedSql(String namedSql, Map<String, Object> paramMap) {
        void var2_2;
        void var1_1;
        this.parse((String)var1_1, (Map<String, Object>)var2_2);
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParams() {
        return this.params.toArray(new Object[0]);
    }

    public List<Object> getParamList() {
        return this.params;
    }

    /*
     * WARNING - void declaration
     */
    private void parse(String namedSql, Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            this.sql = namedSql;
            return;
        }
        int len = namedSql.length();
        StrBuilder name = StrUtil.strBuilder();
        StrBuilder sqlBuilder = StrUtil.strBuilder();
        Character nameStartChar = null;
        for (int i = 0; i < len; ++i) {
            char c = namedSql.charAt(i);
            if (ArrayUtil.contains(NAME_START_CHARS, c)) {
                this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
                nameStartChar = Character.valueOf(c);
                continue;
            }
            if (nameStartChar != null) {
                if (NamedSql.isGenerateChar(c)) {
                    name.append(c);
                    continue;
                }
                this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
                nameStartChar = null;
                sqlBuilder.append(c);
                continue;
            }
            sqlBuilder.append(c);
        }
        if (!name.isEmpty()) {
            void var2_2;
            this.replaceVar(nameStartChar, name, sqlBuilder, (Map<String, Object>)var2_2);
        }
        this.sql = sqlBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void replaceVar(Character nameStartChar, StrBuilder name, StrBuilder sqlBuilder, Map<String, Object> paramMap) {
        void var2_2;
        void var1_1;
        if (name.isEmpty()) {
            if (nameStartChar != null) {
                sqlBuilder.append(nameStartChar);
            }
            return;
        }
        String nameStr = name.toString();
        if (paramMap.containsKey(nameStr)) {
            Object paramValue = paramMap.get(nameStr);
            if (ArrayUtil.isArray(paramValue) && StrUtil.containsIgnoreCase(sqlBuilder, "in")) {
                int length = ArrayUtil.length(paramValue);
                for (int i = 0; i < length; ++i) {
                    if (i != 0) {
                        sqlBuilder.append(',');
                    }
                    sqlBuilder.append('?');
                    this.params.add(ArrayUtil.get(paramValue, i));
                }
            } else {
                sqlBuilder.append('?');
                this.params.add(var1_1);
            }
        } else {
            void var3_3;
            var3_3.append(var1_1).append(name);
        }
        var2_2.clear();
    }

    private static boolean isGenerateChar(char c) {
        char c2;
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c2 <= '9';
    }
}

