/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.clone.CloneSupport;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.sql.LogicalOperator;
import cn.hutool.db.sql.SqlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Condition
extends CloneSupport<Condition> {
    private static final String OPERATOR_LIKE = "LIKE";
    private static final String OPERATOR_IN = "IN";
    private static final String OPERATOR_IS = "IS";
    private static final String OPERATOR_IS_NOT = "IS NOT";
    private static final String OPERATOR_BETWEEN = "BETWEEN";
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    private static final String VALUE_NULL = "NULL";
    private String field;
    private String operator;
    private Object value;
    private boolean isPlaceHolder = true;
    private Object secondValue;
    private LogicalOperator linkOperator = LogicalOperator.AND;

    /*
     * WARNING - void declaration
     */
    public static Condition parse(String field, Object expression) {
        void var1_1;
        String string;
        return new Condition(string, var1_1);
    }

    public Condition() {
    }

    /*
     * WARNING - void declaration
     */
    public Condition(boolean isPlaceHolder) {
        void var1_1;
        this.isPlaceHolder = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Condition(String field, Object value) {
        this((String)var1_1, "=", var2_2);
        void var2_2;
        void var1_1;
        this.parseValue();
    }

    /*
     * WARNING - void declaration
     */
    public Condition(String field, String operator, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.field = var1_1;
        this.operator = var2_2;
        this.value = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Condition(String field, String value, LikeType likeType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.field = var1_1;
        this.operator = OPERATOR_LIKE;
        this.value = SqlUtil.buildLikeValue((String)var2_2, (LikeType)var3_3, false);
    }

    public String getField() {
        return this.field;
    }

    /*
     * WARNING - void declaration
     */
    public void setField(String field) {
        void var1_1;
        this.field = var1_1;
    }

    public String getOperator() {
        return this.operator;
    }

    /*
     * WARNING - void declaration
     */
    public void setOperator(String operator) {
        void var1_1;
        this.operator = var1_1;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(Object value) {
        void var1_1;
        this.setValue(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(Object value, boolean isParse) {
        void var2_2;
        void var1_1;
        this.value = var1_1;
        if (var2_2 != false) {
            this.parseValue();
        }
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlaceHolder(boolean isPlaceHolder) {
        void var1_1;
        this.isPlaceHolder = var1_1;
    }

    public boolean isOperatorBetween() {
        return OPERATOR_BETWEEN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIn() {
        return OPERATOR_IN.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorIs() {
        return OPERATOR_IS.equalsIgnoreCase(this.operator);
    }

    public boolean isOperatorLike() {
        return OPERATOR_LIKE.equalsIgnoreCase(this.operator);
    }

    public Condition checkValueNull() {
        if (this.value == null) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
        }
        return this;
    }

    public Object getSecondValue() {
        return this.secondValue;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecondValue(Object secondValue) {
        void var1_1;
        this.secondValue = var1_1;
    }

    public LogicalOperator getLinkOperator() {
        return this.linkOperator;
    }

    /*
     * WARNING - void declaration
     */
    public void setLinkOperator(LogicalOperator linkOperator) {
        void var1_1;
        this.linkOperator = var1_1;
    }

    public String toString() {
        return this.toString(null);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(List<Object> paramValues) {
        void var2_2;
        StringBuilder conditionStrBuilder = StrUtil.builder();
        this.checkValueNull();
        conditionStrBuilder.append(this.field).append(" ").append(this.operator);
        if (this.isOperatorBetween()) {
            this.buildValuePartForBETWEEN(conditionStrBuilder, paramValues);
        } else if (this.isOperatorIn()) {
            this.buildValuePartForIN(conditionStrBuilder, paramValues);
        } else if (this.isPlaceHolder() && !this.isOperatorIs()) {
            conditionStrBuilder.append(" ?");
            if (paramValues != null) {
                paramValues.add(this.value);
            }
        } else {
            void var1_1;
            String valueStr = String.valueOf(this.value);
            conditionStrBuilder.append(" ").append((String)(this.isOperatorLike() ? StrUtil.wrap(valueStr, "'") : var1_1));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void buildValuePartForBETWEEN(StringBuilder conditionStrBuilder, List<Object> paramValues) {
        if (this.isPlaceHolder()) {
            conditionStrBuilder.append(" ?");
            if (paramValues != null) {
                paramValues.add(this.value);
            }
        } else {
            conditionStrBuilder.append(' ').append(this.value);
        }
        conditionStrBuilder.append(" ").append((Object)LogicalOperator.AND);
        if (this.isPlaceHolder()) {
            conditionStrBuilder.append(" ?");
            if (paramValues != null) {
                void var2_2;
                var2_2.add(this.secondValue);
                return;
            }
        } else {
            void var1_1;
            var1_1.append(' ').append(this.secondValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildValuePartForIN(StringBuilder conditionStrBuilder, List<Object> paramValues) {
        void var1_1;
        void var3_3;
        conditionStrBuilder.append(" (");
        Object value = this.value;
        if (this.isPlaceHolder()) {
            List<Object> valuesForIn;
            valuesForIn = value instanceof Collection ? (List<String>)value : (valuesForIn instanceof CharSequence ? StrUtil.split((CharSequence)((Object)valuesForIn), ',') : Arrays.asList(Convert.convert(Object[].class, (Object)valuesForIn)));
            conditionStrBuilder.append(StrUtil.repeatAndJoin("?", valuesForIn.size(), ","));
            if (paramValues != null) {
                void var2_2;
                var2_2.addAll(var3_3);
            }
        } else {
            conditionStrBuilder.append(StrUtil.join((CharSequence)",", var3_3));
        }
        var1_1.append(')');
    }

    /*
     * WARNING - void declaration
     */
    private void parseValue() {
        void var2_2;
        String valuePart;
        List<String> strs;
        if (this.value == null) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
            return;
        }
        if (this.value instanceof Collection || ArrayUtil.isArray(this.value)) {
            this.operator = OPERATOR_IN;
            return;
        }
        if (!(this.value instanceof String)) {
            return;
        }
        String valueStr = (String)this.value;
        if (StrUtil.isBlank(valueStr)) {
            return;
        }
        if (StrUtil.endWithIgnoreCase(valueStr = StrUtil.trim(valueStr), "null")) {
            if (StrUtil.equalsIgnoreCase("= null", valueStr) || StrUtil.equalsIgnoreCase("is null", valueStr)) {
                this.operator = OPERATOR_IS;
                this.value = VALUE_NULL;
                this.isPlaceHolder = false;
                return;
            }
            if (StrUtil.equalsIgnoreCase("!= null", valueStr) || StrUtil.equalsIgnoreCase("is not null", valueStr)) {
                this.operator = OPERATOR_IS_NOT;
                this.value = VALUE_NULL;
                this.isPlaceHolder = false;
                return;
            }
        }
        if ((strs = StrUtil.split(valueStr, ' ', 2)).size() < 2) {
            return;
        }
        String firstPart = strs.get(0).trim().toUpperCase();
        if (OPERATORS.contains(firstPart)) {
            this.operator = firstPart;
            valuePart = strs.get(1);
            this.value = this.isOperatorIn() ? valuePart : Condition.tryToNumber(valuePart);
            return;
        }
        if (OPERATOR_LIKE.equals(firstPart)) {
            this.operator = OPERATOR_LIKE;
            this.value = Condition.unwrapQuote((String)valuePart.get(1));
            return;
        }
        if (OPERATOR_BETWEEN.equals(var2_2)) {
            void var1_1;
            List<String> betweenValueStrs = StrSplitter.splitTrimIgnoreCase((CharSequence)valuePart.get(1), LogicalOperator.AND.toString(), 2, true);
            if (betweenValueStrs.size() < 2) {
                return;
            }
            this.operator = OPERATOR_BETWEEN;
            this.value = Condition.unwrapQuote(betweenValueStrs.get(0));
            this.secondValue = Condition.unwrapQuote((String)var1_1.get(1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String unwrapQuote(String value) {
        void var2_2;
        String string;
        void var1_1;
        void var3_3;
        if (value == null) {
            return null;
        }
        value = value.trim();
        boolean from = false;
        int to = value.length();
        char startChar = value.charAt(0);
        String string2 = value;
        char endChar = string2.charAt(string2.length() - 1);
        if (startChar == endChar && ('\'' == startChar || 34 == var3_3)) {
            from = true;
            --to;
        }
        if (var1_1 == false) {
            return value;
        }
        return string.substring(1, (int)var2_2);
    }

    private static Object tryToNumber(String value) {
        if (!NumberUtil.isNumber(value = StrUtil.trim(value))) {
            return value;
        }
        try {
            return NumberUtil.parseNumber(value);
        }
        catch (Exception exception) {
            String string;
            return string;
        }
    }

    public static enum LikeType {
        StartWith,
        EndWith,
        Contains;

    }
}

