/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.mongo;

import cn.hutool.core.exceptions.NotInitedException;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.log.Log;
import cn.hutool.setting.AbsSetting;
import cn.hutool.setting.Setting;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.SocketSettings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;

public class MongoDS
implements Closeable {
    private static final Log log = Log.get();
    public static final String MONGO_CONFIG_PATH = "config/mongo.setting";
    private Setting setting;
    private String[] groups;
    private ServerAddress serverAddress;
    private MongoClient mongo;

    /*
     * WARNING - void declaration
     */
    public MongoDS(String host, int port) {
        void var2_2;
        void var1_1;
        this.serverAddress = this.createServerAddress((String)var1_1, (int)var2_2);
        this.initSingle();
    }

    /*
     * WARNING - void declaration
     */
    public MongoDS(Setting mongoSetting, String host, int port) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setting = var1_1;
        this.serverAddress = this.createServerAddress((String)var2_2, (int)var3_3);
        this.initSingle();
    }

    /*
     * WARNING - void declaration
     */
    public MongoDS(String ... groups) {
        void var1_1;
        this.groups = var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public MongoDS(Setting mongoSetting, String ... groups) {
        void var2_2;
        void var1_1;
        if (mongoSetting == null) {
            throw new DbRuntimeException("Mongo setting is null!");
        }
        this.setting = var1_1;
        this.groups = var2_2;
        this.init();
    }

    public void init() {
        if (this.groups != null && this.groups.length > 1) {
            this.initCloud();
            return;
        }
        this.initSingle();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void initSingle() {
        if (this.setting == null) {
            try {
                this.setting = new Setting(MONGO_CONFIG_PATH, true);
            }
            catch (Exception exception) {}
        }
        String group = "";
        if (this.serverAddress == null) {
            if (this.groups != null && this.groups.length == 1) {
                group = this.groups[0];
            }
            this.serverAddress = this.createServerAddress(group);
        }
        MongoCredential credentail = this.createCredentail(group);
        try {
            void var1_1;
            MongoClientSettings.Builder clusterSettingsBuilder = MongoClientSettings.builder().applyToClusterSettings(b -> b.hosts(Collections.singletonList(this.serverAddress)));
            this.buildMongoClientSettings(clusterSettingsBuilder, (String)var1_1);
            if (credentail != null) {
                void var2_2;
                clusterSettingsBuilder.credential((MongoCredential)var2_2);
            }
            this.mongo = MongoClients.create((MongoClientSettings)clusterSettingsBuilder.build());
        }
        catch (Exception e) {
            void var3_4;
            throw new DbRuntimeException(StrUtil.format("Init MongoDB pool with connection to [{}] error!", this.serverAddress), (Throwable)var3_4);
        }
        log.info("Init MongoDB pool with connection to [{}]", this.serverAddress);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void initCloud() {
        void var1_1;
        if (this.groups == null || this.groups.length == 0) {
            throw new DbRuntimeException("Please give replication set groups!");
        }
        if (this.setting == null) {
            this.setting = new Setting(MONGO_CONFIG_PATH, true);
        }
        ArrayList<ServerAddress> addrList = new ArrayList<ServerAddress>();
        String[] stringArray = this.groups;
        int n = this.groups.length;
        for (int i = 0; i < n; ++i) {
            String group = stringArray[i];
            addrList.add(this.createServerAddress(group));
        }
        MongoCredential credentail = this.createCredentail("");
        try {
            MongoClientSettings.Builder clusterSettingsBuilder = MongoClientSettings.builder().applyToClusterSettings(b -> {
                List list;
                b.hosts(list);
            });
            this.buildMongoClientSettings(clusterSettingsBuilder, "");
            if (credentail != null) {
                clusterSettingsBuilder.credential((MongoCredential)stringArray);
            }
            this.mongo = MongoClients.create((MongoClientSettings)clusterSettingsBuilder.build());
        }
        catch (Exception e) {
            void var3_5;
            log.error((Throwable)var3_5, "Init MongoDB connection error!", new Object[0]);
            return;
        }
        log.info("Init MongoDB cloud Set pool with connection to {}", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSetting(Setting setting) {
        void var1_1;
        this.setting = var1_1;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    /*
     * WARNING - void declaration
     */
    public MongoDatabase getDb(String dbName) {
        void var1_1;
        return this.mongo.getDatabase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MongoCollection<Document> getCollection(String dbName, String collectionName) {
        void var2_2;
        void var1_1;
        return this.getDb((String)var1_1).getCollection((String)var2_2);
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    /*
     * WARNING - void declaration
     */
    private ServerAddress createServerAddress(String group) {
        void var1_2;
        void var3_4;
        void var2_3;
        String tmpHost;
        Setting setting = this.checkSetting();
        if (group == null) {
            group = "";
        }
        if (StrUtil.isBlank(tmpHost = ((AbsSetting)setting).getByGroup("host", group))) {
            throw new NotInitedException("Host name is empy of group: {}", group);
        }
        int defaultPort = var2_3.getInt("port", group, 27017);
        return new ServerAddress(NetUtil.buildInetSocketAddress((String)var3_4, (int)var1_2));
    }

    /*
     * WARNING - void declaration
     */
    private ServerAddress createServerAddress(String host, int port) {
        void var2_2;
        void var1_1;
        return new ServerAddress((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private MongoCredential createCredentail(String group) {
        void var1_1;
        void var3_3;
        void var2_2;
        Setting setting = this.setting;
        if (setting == null) {
            return null;
        }
        String user = setting.getStr("user", group, setting.getStr("user"));
        String pass = setting.getStr("pass", group, setting.getStr("pass"));
        String database = setting.getStr("database", group, var2_2.getStr("database"));
        return this.createCredentail((String)var3_3, (String)var1_1, pass);
    }

    /*
     * WARNING - void declaration
     */
    private MongoCredential createCredentail(String userName, String database, String password) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (StrUtil.hasEmpty(userName, database, database)) {
            return null;
        }
        return MongoCredential.createCredential((String)var1_1, (String)var2_2, (char[])var3_3.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    private MongoClientSettings.Builder buildMongoClientSettings(MongoClientSettings.Builder builder, String group) {
        void var1_1;
        if (this.setting == null) {
            return builder;
        }
        group = StrUtil.isEmpty(group) ? "" : group + ".";
        Integer connectionsPerHost = this.setting.getInt(group + "connectionsPerHost");
        if (!StrUtil.isBlank(group) && connectionsPerHost == null) {
            connectionsPerHost = this.setting.getInt("connectionsPerHost");
        }
        ConnectionPoolSettings.Builder connectionPoolSettingsBuilder = ConnectionPoolSettings.builder();
        if (connectionsPerHost != null) {
            connectionPoolSettingsBuilder.maxSize(connectionsPerHost.intValue());
            log.debug("MongoDB connectionsPerHost: {}", connectionsPerHost);
        }
        Integer connectTimeout = this.setting.getInt(group + "connectTimeout");
        if (!StrUtil.isBlank(group) && connectTimeout == null) {
            this.setting.getInt("connectTimeout");
        }
        if (connectTimeout != null) {
            connectionPoolSettingsBuilder.maxWaitTime((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS);
            log.debug("MongoDB connectTimeout: {}", connectTimeout);
        }
        builder.applyToConnectionPoolSettings(b -> {
            ConnectionPoolSettings.Builder builder;
            b.applySettings(builder.build());
        });
        Integer socketTimeout = this.setting.getInt(group + "socketTimeout");
        if (!StrUtil.isBlank(group) && socketTimeout == null) {
            this.setting.getInt("socketTimeout");
        }
        if (socketTimeout != null) {
            void var3_3;
            void var2_2;
            SocketSettings socketSettings = SocketSettings.builder().connectTimeout(socketTimeout.intValue(), TimeUnit.MILLISECONDS).build();
            builder.applyToSocketSettings(arg_0 -> MongoDS.lambda$buildMongoClientSettings$3((SocketSettings)var2_2, arg_0));
            log.debug("MongoDB socketTimeout: {}", var3_3);
        }
        return var1_1;
    }

    private Setting checkSetting() {
        if (this.setting == null) {
            throw new DbRuntimeException("Please indicate setting file or create default [{}]", MONGO_CONFIG_PATH);
        }
        return this.setting;
    }

    private static /* synthetic */ void lambda$buildMongoClientSettings$3(SocketSettings socketSettings, SocketSettings.Builder b) {
        SocketSettings socketSettings2;
        b.applySettings(socketSettings2);
    }
}

