/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.meta;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.ColumnIndexInfo;
import cn.hutool.db.meta.IndexInfo;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;

public class MetaUtil {
    public static List<String> getTables(DataSource ds) {
        return MetaUtil.getTables(ds, TableType.TABLE);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getTables(DataSource ds, TableType ... types) {
        void var1_1;
        return MetaUtil.getTables(ds, null, null, (TableType[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getTables(DataSource ds, String schema, TableType ... types) {
        void var2_2;
        void var1_1;
        return MetaUtil.getTables(ds, (String)var1_1, null, (TableType[])var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getTables(DataSource ds, String schema, String tableName, TableType ... types) {
        Connection conn;
        ArrayList<String> tables;
        block14: {
            tables = new ArrayList<String>();
            conn = null;
            try {
                Throwable throwable;
                void var3_7;
                Throwable throwable2;
                conn = ds.getConnection();
                String catalog = MetaUtil.getCatalog(conn);
                if (schema == null) {
                    schema = MetaUtil.getSchema(conn);
                }
                DatabaseMetaData databaseMetaData = conn.getMetaData();
                String rs2 = databaseMetaData.getTables(catalog, (String)((Object)throwable2), tableName, Convert.toStrArray(var3_7));
                throwable2 = null;
                try {
                    if (rs2 != null) {
                        while (rs2.next()) {
                            String table = rs2.getString("TABLE_NAME");
                            if (!StrUtil.isNotBlank(table)) continue;
                            tables.add((String)((Object)throwable));
                        }
                    }
                    if (rs2 == null) break block14;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throwable2 = throwable3;
                        throw throwable;
                    }
                    catch (Throwable throwable4) {
                        if (rs2 == null) throw throwable4;
                        if (throwable2 == null) {
                            rs2.close();
                            throw throwable4;
                        }
                        try {
                            rs2.close();
                            throw throwable4;
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                            throw throwable4;
                        }
                    }
                }
                rs2.close();
            }
            catch (Exception e) {
                try {
                    void var0_2;
                    throw new DbRuntimeException("Get tables error!", (Throwable)var0_2);
                }
                catch (Throwable throwable) {
                    DbUtil.close(conn);
                    throw throwable;
                }
            }
        }
        DbUtil.close(conn);
        return tables;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getColumnNames(ResultSet rs) throws DbRuntimeException {
        try {
            void var1_3;
            Wrapper rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            String[] labelNames = new String[n];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return var1_3;
        }
        catch (Exception e) {
            void var0_1;
            throw new DbRuntimeException("Get colunms error!", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] rs2;
        Serializable columnNames2 = new ArrayList();
        Connection conn = null;
        try {
            void var2_5;
            block13: {
                Throwable throwable;
                conn = ds.getConnection();
                String[] catalog = MetaUtil.getCatalog(conn);
                String schema = MetaUtil.getSchema(conn);
                DatabaseMetaData databaseMetaData = conn.getMetaData();
                rs2 = databaseMetaData.getColumns((String)catalog, schema, (String)((Object)throwable), null);
                throwable = null;
                try {
                    if (rs2 != null) {
                        while (rs2.next()) {
                            columnNames2.add(rs2.getString("COLUMN_NAME"));
                        }
                    }
                    if (rs2 == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        columnNames2 = throwable2;
                        throwable = throwable2;
                        throw columnNames2;
                    }
                    catch (Throwable columnNames2) {
                        if (rs2 == null) throw columnNames2;
                        if (throwable == null) {
                            rs2.close();
                            throw columnNames2;
                        }
                        try {
                            rs2.close();
                            throw columnNames2;
                        }
                        catch (Throwable rs2) {
                            throwable.addSuppressed(rs2);
                            throw columnNames2;
                        }
                    }
                }
                rs2.close();
            }
            rs2 = var2_5.toArray(new String[0]);
        }
        catch (Exception e) {
            try {
                void var0_2;
                throw new DbRuntimeException("Get columns error!", (Throwable)var0_2);
            }
            catch (Throwable throwable) {
                void var3_7;
                DbUtil.close(var3_7);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return rs2;
    }

    /*
     * WARNING - void declaration
     */
    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] stringArray;
        void var1_1;
        String[] columnNames = MetaUtil.getColumnNames(ds, tableName);
        return Entity.create((String)var1_1).setFieldNames(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public static Table getTableMeta(DataSource ds, String tableName) {
        void var1_1;
        return MetaUtil.getTableMeta(ds, null, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Table getTableMeta(DataSource ds, String catalog22, String schema, String tableName) {
        Connection conn;
        Table table;
        block45: {
            table = Table.create(tableName);
            conn = null;
            try {
                Serializable indexInfoMap2;
                String catalog22;
                Throwable throwable;
                ResultSet rs;
                Serializable metaData2;
                block44: {
                    block43: {
                        block42: {
                            conn = ds.getConnection();
                            if (catalog22 == null) {
                                catalog22 = MetaUtil.getCatalog(conn);
                            }
                            table.setCatalog(catalog22);
                            if (schema == null) {
                                schema = MetaUtil.getSchema(conn);
                            }
                            table.setSchema(schema);
                            metaData2 = conn.getMetaData();
                            rs = metaData2.getTables(catalog22, schema, tableName, new String[]{TableType.TABLE.value()});
                            throwable = null;
                            try {
                                if (rs != null && rs.next()) {
                                    table.setComment(rs.getString("REMARKS"));
                                }
                                if (rs == null) break block42;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    metaData2 = throwable2;
                                    throwable = throwable2;
                                    throw metaData2;
                                }
                                catch (Throwable throwable3) {
                                    if (rs == null) throw throwable3;
                                    if (throwable == null) {
                                        rs.close();
                                        throw throwable3;
                                    }
                                    try {
                                        rs.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            rs.close();
                        }
                        rs = metaData2.getPrimaryKeys(catalog22, schema, tableName);
                        throwable = null;
                        try {
                            if (rs != null) {
                                while (rs.next()) {
                                    table.addPk(rs.getString("COLUMN_NAME"));
                                }
                            }
                            if (rs == null) break block43;
                        }
                        catch (Throwable throwable5) {
                            try {
                                metaData2 = throwable5;
                                throwable = throwable5;
                                throw metaData2;
                            }
                            catch (Throwable throwable6) {
                                if (rs == null) throw throwable6;
                                if (throwable == null) {
                                    rs.close();
                                    throw throwable6;
                                }
                                try {
                                    rs.close();
                                    throw throwable6;
                                }
                                catch (Throwable metaData2) {
                                    throwable.addSuppressed(metaData2);
                                    throw throwable6;
                                }
                            }
                        }
                        rs.close();
                    }
                    rs = metaData2.getColumns(catalog22, schema, tableName, null);
                    throwable = null;
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                Table table2 = table;
                                table2.setColumn(Column.create(table2, rs));
                            }
                        }
                        if (rs == null) break block44;
                    }
                    catch (Throwable throwable7) {
                        try {
                            metaData2 = throwable7;
                            throwable = throwable7;
                            throw metaData2;
                        }
                        catch (Throwable metaData2) {
                            if (rs == null) throw metaData2;
                            if (throwable == null) {
                                rs.close();
                                throw metaData2;
                            }
                            try {
                                rs.close();
                                throw metaData2;
                            }
                            catch (Throwable catalog22) {
                                throwable.addSuppressed(catalog22);
                                throw metaData2;
                            }
                        }
                    }
                    rs.close();
                }
                rs = metaData2.getIndexInfo(catalog22, schema, tableName, false, false);
                throwable = null;
                try {
                    indexInfoMap2 = new LinkedHashMap();
                    if (rs != null) {
                        while (rs.next()) {
                            if (0 == rs.getShort("TYPE")) continue;
                            String indexName = rs.getString("INDEX_NAME");
                            String key = StrUtil.join((CharSequence)"&", tableName, indexName);
                            IndexInfo indexInfo = (IndexInfo)indexInfoMap2.get(key);
                            if (indexInfo == null) {
                                indexInfo = new IndexInfo(rs.getBoolean("NON_UNIQUE"), indexName, tableName, schema, catalog22);
                                indexInfoMap2.put(key, indexInfo);
                            }
                            indexInfo.getColumnIndexInfoList().add(ColumnIndexInfo.create(rs));
                        }
                    }
                    table.setIndexInfoList(ListUtil.toList(indexInfoMap2.values()));
                    if (rs == null) break block45;
                }
                catch (Throwable throwable8) {
                    try {
                        indexInfoMap2 = throwable8;
                        throwable = throwable8;
                        throw indexInfoMap2;
                    }
                    catch (Throwable indexInfoMap2) {
                        if (rs == null) throw indexInfoMap2;
                        if (throwable == null) {
                            rs.close();
                            throw indexInfoMap2;
                        }
                        try {
                            rs.close();
                            throw indexInfoMap2;
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                            throw indexInfoMap2;
                        }
                    }
                }
                rs.close();
            }
            catch (SQLException e) {
                try {
                    void var0_4;
                    throw new DbRuntimeException("Get columns error!", (Throwable)var0_4);
                }
                catch (Throwable throwable) {
                    DbUtil.close(conn);
                    throw throwable;
                }
            }
        }
        DbUtil.close(conn);
        return table;
    }

    @Deprecated
    public static String getCataLog(Connection conn) {
        return MetaUtil.getCatalog(conn);
    }

    public static String getCatalog(Connection conn) {
        if (conn == null) {
            return null;
        }
        try {
            Connection connection;
            return connection.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (conn == null) {
            return null;
        }
        try {
            Connection connection;
            return connection.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

