/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.meta;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.meta.JdbcType;
import cn.hutool.db.meta.Table;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Column
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 577527740359719367L;
    private String tableName;
    private String name;
    private int type;
    private String typeName;
    private long size;
    private Integer digit;
    private boolean isNullable;
    private String comment;
    private boolean autoIncrement;
    private String columnDef;
    private boolean isPk;

    /*
     * WARNING - void declaration
     */
    public static Column create(Table table, ResultSet columnMetaRs) {
        void var1_1;
        Table table2;
        return new Column(table2, (ResultSet)var1_1);
    }

    public Column() {
    }

    /*
     * WARNING - void declaration
     */
    public Column(Table table, ResultSet columnMetaRs) {
        try {
            void var2_3;
            this.init(table, (ResultSet)var2_3);
            return;
        }
        catch (SQLException e) {
            void var1_2;
            throw new DbRuntimeException((Throwable)var1_2, "Get table [{}] meta info error!", this.tableName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(Table table, ResultSet columnMetaRs) throws SQLException {
        String string;
        this.tableName = table.getTableName();
        this.name = columnMetaRs.getString("COLUMN_NAME");
        this.isPk = table.isPk(this.name);
        this.type = columnMetaRs.getInt("DATA_TYPE");
        String typeName = columnMetaRs.getString("TYPE_NAME");
        typeName = ReUtil.delLast("\\(\\d+\\)", (CharSequence)typeName);
        this.typeName = string;
        this.size = columnMetaRs.getLong("COLUMN_SIZE");
        this.isNullable = columnMetaRs.getBoolean("NULLABLE");
        this.comment = columnMetaRs.getString("REMARKS");
        this.columnDef = columnMetaRs.getString("COLUMN_DEF");
        try {
            this.digit = columnMetaRs.getInt("DECIMAL_DIGITS");
        }
        catch (SQLException sQLException) {}
        try {
            void var2_2;
            string = var2_2.getString("IS_AUTOINCREMENT");
            if (BooleanUtil.toBoolean(string)) {
                this.autoIncrement = true;
            }
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - void declaration
     */
    public Column setTableName(String tableName) {
        void var1_1;
        this.tableName = var1_1;
        return this;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public Column setName(String name) {
        void var1_1;
        this.name = var1_1;
        return this;
    }

    public JdbcType getTypeEnum() {
        return JdbcType.valueOf(this.type);
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public Column setType(int type) {
        void var1_1;
        this.type = var1_1;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    /*
     * WARNING - void declaration
     */
    public Column setTypeName(String typeName) {
        void var1_1;
        this.typeName = var1_1;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public Column setSize(int size) {
        void var1_1;
        this.size = (long)var1_1;
        return this;
    }

    public Integer getDigit() {
        return this.digit;
    }

    /*
     * WARNING - void declaration
     */
    public Column setDigit(int digit) {
        void var1_1;
        this.digit = (int)var1_1;
        return this;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    /*
     * WARNING - void declaration
     */
    public Column setNullable(boolean isNullable) {
        void var1_1;
        this.isNullable = var1_1;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    /*
     * WARNING - void declaration
     */
    public Column setComment(String comment) {
        void var1_1;
        this.comment = var1_1;
        return this;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    /*
     * WARNING - void declaration
     */
    public Column setAutoIncrement(boolean autoIncrement) {
        void var1_1;
        this.autoIncrement = var1_1;
        return this;
    }

    public boolean isPk() {
        return this.isPk;
    }

    /*
     * WARNING - void declaration
     */
    public Column setPk(boolean isPk) {
        void var1_1;
        this.isPk = var1_1;
        return this;
    }

    public String getColumnDef() {
        return this.columnDef;
    }

    /*
     * WARNING - void declaration
     */
    public Column setColumnDef(String columnDef) {
        void var1_1;
        this.columnDef = var1_1;
        return this;
    }

    public String toString() {
        return "Column [tableName=" + this.tableName + ", name=" + this.name + ", type=" + this.type + ", size=" + this.size + ", isNullable=" + this.isNullable + "]";
    }

    public Column clone() throws CloneNotSupportedException {
        return (Column)super.clone();
    }
}

