/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.db.Entity;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HandleHelper {
    /*
     * WARNING - void declaration
     */
    public static <T> T handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, T bean) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return HandleHelper.handleRow(columnCount, (ResultSetMetaData)var1_1, (ResultSet)var2_2).toBeanIgnoreCase(var3_3);
    }

    public static <T> T handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, Class<T> beanClass) throws SQLException {
        T[] result;
        Assert.notNull(beanClass, "Bean Class must be not null !", new Object[0]);
        if (beanClass.isArray()) {
            Class<?> componentType = beanClass.getComponentType();
            result = ArrayUtil.newArray(componentType, columnCount);
            int i = 0;
            int j = 1;
            while (i < columnCount) {
                result[i] = HandleHelper.getColumnValue(rs, j, meta.getColumnType(j), componentType);
                ++i;
                ++j;
            }
            return (T)result;
        }
        if (Iterable.class.isAssignableFrom((Class<?>)result)) {
            Object[] objRow = HandleHelper.handleRow(columnCount, meta, rs, Object[].class);
            return Convert.convert(result, (Object)objRow);
        }
        if (result.isAssignableFrom(Entity.class)) {
            return (T)HandleHelper.handleRow(columnCount, meta, rs);
        }
        if (String.class == result) {
            Object[] objRow = HandleHelper.handleRow(columnCount, meta, rs, Object[].class);
            return (T)StrUtil.join((CharSequence)", ", objRow);
        }
        Object bean = ReflectUtil.newInstanceIfPossible(result);
        Map<String, PropDesc> propMap = BeanUtil.getBeanDesc(result).getPropMap(true);
        for (int i = 1; i <= columnCount; ++i) {
            Method setter;
            String columnLabel = meta.getColumnLabel(i);
            PropDesc pd = propMap.get(columnLabel);
            if (pd == null) {
                pd = propMap.get(StrUtil.toCamelCase(columnLabel));
            }
            Method method = setter = pd == null ? null : pd.getSetter();
            if (setter == null) continue;
            Object value = HandleHelper.getColumnValue(rs, i, meta.getColumnType(i), TypeUtil.getFirstParamType(setter));
            ReflectUtil.invokeWithCheck(bean, setter, value);
        }
        return bean;
    }

    /*
     * WARNING - void declaration
     */
    public static Entity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs) throws SQLException {
        void var2_2;
        void var1_1;
        return HandleHelper.handleRow(columnCount, (ResultSetMetaData)var1_1, (ResultSet)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Entity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, boolean caseInsensitive) throws SQLException {
        void var2_2;
        void var1_1;
        int n;
        void var3_3;
        return HandleHelper.handleRow(new Entity(null, (boolean)var3_3), n, (ResultSetMetaData)var1_1, (ResultSet)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Entity> T handleRow(T row, int columnCount, ResultSetMetaData meta, ResultSet rs, boolean withMetaInfo) throws SQLException {
        T t;
        for (int i = 1; i <= columnCount; ++i) {
            int type = meta.getColumnType(i);
            String columnLabel = meta.getColumnLabel(i);
            if ("rownum_".equalsIgnoreCase(columnLabel)) continue;
            row.put(columnLabel, HandleHelper.getColumnValue(rs, i, type, null));
        }
        if (withMetaInfo) {
            try {
                void var2_2;
                row.setTableName(var2_2.getTableName(1));
            }
            catch (SQLException sQLException) {}
            T t2 = row;
            t2.setFieldNames(t2.keySet());
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static Entity handleRow(ResultSet rs) throws SQLException {
        ResultSet resultSet;
        void var1_1;
        ResultSetMetaData meta = rs.getMetaData();
        int n = meta.getColumnCount();
        return HandleHelper.handleRow(n, (ResultSetMetaData)var1_1, resultSet);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> handleRowToList(ResultSet rs) throws SQLException {
        void var3_3;
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ArrayList<Object> row = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            row.add(HandleHelper.getColumnValue(rs, i, meta.getColumnType(i), null));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<Entity>> T handleRs(ResultSet rs, T collection) throws SQLException {
        void var1_1;
        return HandleHelper.handleRs(rs, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<Entity>> T handleRs(ResultSet rs, T collection, boolean caseInsensitive) throws SQLException {
        void var1_1;
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add((Entity)HandleHelper.handleRow(columnCount, meta, rs, caseInsensitive));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <E, T extends Collection<E>> T handleRsToBeanList(ResultSet rs, T collection, Class<E> elementBeanType) throws SQLException {
        void var1_1;
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add(HandleHelper.handleRow(columnCount, meta, rs, elementBeanType));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Object getColumnValue(ResultSet rs, int columnIndex, int type, Type targetColumnType) throws SQLException {
        void var3_3;
        void var2_2;
        Object rawValue = null;
        switch (var2_2) {
            case 93: {
                try {
                    rawValue = rs.getTimestamp(columnIndex);
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 92: {
                rawValue = rs.getTime(columnIndex);
                break;
            }
            default: {
                void var1_1;
                ResultSet resultSet;
                rawValue = resultSet.getObject((int)var1_1);
            }
        }
        if (targetColumnType == null || Object.class == targetColumnType) {
            return rawValue;
        }
        return Convert.convert((Type)var3_3, rawValue);
    }
}

