/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.simple;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.simple.AbstractDataSource;
import cn.hutool.setting.Setting;
import cn.hutool.setting.dialect.Props;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class SimpleDataSource
extends AbstractDataSource {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private String driver;
    private String url;
    private String user;
    private String pass;
    private Properties connProps;

    public static synchronized SimpleDataSource getDataSource(String group) {
        String string;
        return new SimpleDataSource(string);
    }

    public static synchronized SimpleDataSource getDataSource() {
        return new SimpleDataSource();
    }

    public SimpleDataSource() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public SimpleDataSource(String group) {
        this(null, (String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleDataSource(Setting setting, String group) {
        void var1_1;
        Setting config;
        if (setting == null) {
            setting = new Setting(DEFAULT_DB_CONFIG_PATH);
        }
        if (MapUtil.isEmpty(config = setting.getSetting(group))) {
            void var2_2;
            throw new DbRuntimeException("No DataSource config for group: [{}]", var2_2);
        }
        this.init(config.getAndRemoveStr(DSFactory.KEY_ALIAS_URL), config.getAndRemoveStr(DSFactory.KEY_ALIAS_USER), config.getAndRemoveStr(DSFactory.KEY_ALIAS_PASSWORD), config.getAndRemoveStr(DSFactory.KEY_ALIAS_DRIVER));
        this.connProps = var1_1.getProps("");
    }

    /*
     * WARNING - void declaration
     */
    public SimpleDataSource(String url, String user, String pass) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public SimpleDataSource(String url, String user, String pass, String driver) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((String)var1_1, (String)var2_2, (String)var3_3, driver);
    }

    /*
     * WARNING - void declaration
     */
    public void init(String url, String user, String pass) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((String)var1_1, (String)var2_2, (String)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void init(String url, String user, String pass, String driver) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.driver = StrUtil.isNotBlank(driver) ? driver : DriverUtil.identifyDriver(url);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            void var1_2;
            throw new DbRuntimeException((Throwable)var1_2, "Get jdbc driver [{}] error!", driver);
        }
        this.url = var1_1;
        this.user = var2_3;
        this.pass = var3_4;
    }

    public String getDriver() {
        return this.driver;
    }

    /*
     * WARNING - void declaration
     */
    public void setDriver(String driver) {
        void var1_1;
        this.driver = var1_1;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     */
    public void setUrl(String url) {
        void var1_1;
        this.url = var1_1;
    }

    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - void declaration
     */
    public void setUser(String user) {
        void var1_1;
        this.user = var1_1;
    }

    public String getPass() {
        return this.pass;
    }

    /*
     * WARNING - void declaration
     */
    public void setPass(String pass) {
        void var1_1;
        this.pass = var1_1;
    }

    public Properties getConnProps() {
        return this.connProps;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnProps(Properties connProps) {
        void var1_1;
        this.connProps = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addConnProps(String key, String value) {
        void var2_2;
        void var1_1;
        if (this.connProps == null) {
            this.connProps = new Properties();
        }
        this.connProps.setProperty((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection getConnection() throws SQLException {
        void var1_1;
        Properties connProps;
        Props info = new Props();
        if (this.user != null) {
            info.setProperty("user", this.user);
        }
        if (this.pass != null) {
            info.setProperty("password", this.pass);
        }
        if (MapUtil.isNotEmpty(connProps = this.connProps)) {
            void var2_2;
            info.putAll((Map<?, ?>)var2_2);
        }
        return DriverManager.getConnection(this.url, (Properties)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        void var2_2;
        void var1_1;
        return DriverManager.getConnection(this.url, (String)var1_1, (String)var2_2);
    }

    @Override
    public void close() {
    }
}

