/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.pooled;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.ds.pooled.DbConfig;
import cn.hutool.db.ds.pooled.DbSetting;
import cn.hutool.db.ds.pooled.PooledConnection;
import cn.hutool.db.ds.simple.AbstractDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;

public class PooledDataSource
extends AbstractDataSource {
    private Queue<PooledConnection> freePool;
    private int activeCount;
    private final DbConfig config;

    public static synchronized PooledDataSource getDataSource(String group) {
        String string;
        return new PooledDataSource(string);
    }

    public static synchronized PooledDataSource getDataSource() {
        return new PooledDataSource();
    }

    public PooledDataSource() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    public PooledDataSource(String group) {
        this(new DbSetting(), (String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PooledDataSource(DbSetting setting, String group) {
        this(var1_1.getDbConfig((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PooledDataSource(DbConfig config) {
        this.config = config;
        this.freePool = new LinkedList<PooledConnection>();
        int initialSize = config.getInitialSize();
        try {
            while (initialSize-- > 0) {
                this.freePool.offer(this.newConnection());
            }
            return;
        }
        catch (SQLException e) {
            void var1_3;
            throw new DbRuntimeException((Throwable)var1_3);
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        PooledDataSource pooledDataSource = this;
        return pooledDataSource.getConnection(pooledDataSource.config.getMaxWait());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Pooled DataSource is not allow to get special Connection!");
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized boolean free(PooledConnection conn) {
        void var1_1;
        --this.activeCount;
        return this.freePool.offer((PooledConnection)var1_1);
    }

    public PooledConnection newConnection() throws SQLException {
        return new PooledConnection(this);
    }

    public DbConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    public PooledConnection getConnection(long wait) throws SQLException {
        try {
            return this.getConnectionDirect();
        }
        catch (Exception exception) {
            void var1_1;
            ThreadUtil.sleep((long)var1_1);
            return this.getConnectionDirect();
        }
    }

    @Override
    public synchronized void close() {
        if (CollectionUtil.isNotEmpty(this.freePool)) {
            this.freePool.forEach(PooledConnection::release);
            this.freePool.clear();
            this.freePool = null;
        }
    }

    protected void finalize() {
        IoUtil.close(this);
    }

    /*
     * WARNING - void declaration
     */
    private PooledConnection getConnectionDirect() throws SQLException {
        void var1_2;
        if (this.freePool == null) {
            throw new SQLException("PooledDataSource is closed!");
        }
        int maxActive = this.config.getMaxActive();
        if (maxActive <= 0 || maxActive < this.activeCount) {
            throw new SQLException("In used Connection is more than Max Active.");
        }
        PooledConnection conn = this.freePool.poll();
        if (conn == null || conn.open().isClosed()) {
            conn = this.newConnection();
        }
        ++this.activeCount;
        return var1_2;
    }
}

