/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds;

import cn.hutool.db.ds.DSFactory;
import cn.hutool.log.StaticLog;

public class GlobalDSFactory {
    private static volatile DSFactory factory;
    private static final Object lock;

    public static DSFactory get() {
        if (factory == null) {
            Object object = lock;
            synchronized (object) {
                if (factory == null) {
                    factory = DSFactory.create(null);
                }
            }
        }
        return factory;
    }

    public static DSFactory set(DSFactory customDSFactory) {
        Object object = lock;
        synchronized (object) {
            DSFactory dSFactory;
            if (factory != null) {
                if (factory.equals(customDSFactory)) {
                    return factory;
                }
                factory.destroy();
            }
            StaticLog.debug("Custom use [{}] DataSource.", customDSFactory.dataSourceName);
            factory = dSFactory;
        }
        return factory;
    }

    static {
        lock = new Object();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public final void run() {
                if (null != factory) {
                    factory.destroy();
                    StaticLog.debug("DataSource: [{}] destroyed.", factory.dataSourceName);
                    factory = null;
                }
            }
        });
    }
}

