/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.DataSourceWrapper;
import cn.hutool.setting.Setting;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractDSFactory
extends DSFactory {
    private static final long serialVersionUID = -6407302276272379881L;
    private final Setting setting;
    private final Map<String, DataSourceWrapper> dsMap;

    /*
     * WARNING - void declaration
     */
    public AbstractDSFactory(String dataSourceName, Class<? extends DataSource> dataSourceClass, Setting setting) {
        super((String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(var2_2);
        if (setting == null) {
            setting = GlobalDbConfig.createDbSetting();
        }
        DbUtil.setShowSqlGlobal(setting);
        this.setting = var3_3;
        this.dsMap = new SafeConcurrentHashMap<String, DataSourceWrapper>();
    }

    public Setting getSetting() {
        return this.setting;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized DataSource getDataSource(String group) {
        void var2_2;
        void var1_1;
        DataSourceWrapper existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DataSourceWrapper ds = this.createDataSource(group);
        this.dsMap.put((String)var1_1, ds);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DataSourceWrapper createDataSource(String group) {
        void var1_1;
        void var2_2;
        void var3_3;
        Setting config;
        if (group == null) {
            group = "";
        }
        if (MapUtil.isEmpty(config = this.setting.getSetting(group))) {
            throw new DbRuntimeException("No config for group: [{}]", group);
        }
        String url = config.getAndRemoveStr(KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        DbUtil.removeShowSqlParams(config);
        String driver = config.getAndRemoveStr(KEY_ALIAS_DRIVER);
        if (StrUtil.isBlank(driver)) {
            driver = DriverUtil.identifyDriver(url);
        }
        String user = config.getAndRemoveStr(KEY_ALIAS_USER);
        String pass = config.getAndRemoveStr(KEY_ALIAS_PASSWORD);
        return DataSourceWrapper.wrap(this.createDataSource((String)var3_3, driver, user, pass, (Setting)var2_2), (String)var1_1);
    }

    protected abstract DataSource createDataSource(String var1, String var2, String var3, String var4, Setting var5);

    /*
     * WARNING - void declaration
     */
    @Override
    public void close(String group) {
        DataSourceWrapper ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            void var1_1;
            void var2_2;
            var2_2.close();
            this.dsMap.remove(var1_1);
        }
    }

    @Override
    public void destroy() {
        if (MapUtil.isNotEmpty(this.dsMap)) {
            Object object = this.dsMap.values();
            object = object.iterator();
            while (object.hasNext()) {
                DataSourceWrapper dataSourceWrapper = (DataSourceWrapper)object.next();
                dataSourceWrapper.close();
            }
            this.dsMap.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = 31 + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
        var1_1 = var1_1 * 31 + (this.setting == null ? 0 : this.setting.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDSFactory other = (AbstractDSFactory)obj;
        if (this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName)) {
            return false;
        }
        if (this.setting == null) {
            return other.setting == null;
        }
        return this.setting.equals(var1_1.setting);
    }
}

