/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.dialect.impl.AnsiSqlDialect;
import cn.hutool.db.sql.SqlBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class H2Dialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 1490520247974768214L;

    @Override
    public String dialectName() {
        return DialectName.H2.name();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        void var2_2;
        return find.append(" limit ").append(page.getStartPosition()).append(" , ").append(var2_2.getPageSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) throws SQLException {
        void var1_1;
        void var3_3;
        void var2_2;
        Assert.notEmpty(keys, "Keys must be not empty for H2 MERGE SQL.", new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field)) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (fieldsPart.length() > 0) {
                    fieldsPart.append(", ");
                    placeHolder.append(", ");
                }
                var1_1.append(null != this.wrapper ? this.wrapper.wrap((String)field) : field);
                var2_2.append("?");
                var3_3.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
            keys = this.wrapper.wrap(keys);
        }
        builder.append("MERGE INTO ").append(var2_2).append(" (").append(fieldsPart).append(") KEY(").append(ArrayUtil.join(var3_3, (CharSequence)", ")).append(") VALUES (").append(placeHolder).append(")");
        return StatementUtil.prepareStatement((Connection)var1_1, builder);
    }
}

