/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;

public class AnsiSqlDialect
implements Dialect {
    private static final long serialVersionUID = 2088101129774974580L;
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setWrapper(Wrapper wrapper) {
        void var1_1;
        this.wrapper = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        void var2_2;
        void var1_1;
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        return StatementUtil.prepareStatement((Connection)var1_1, (SqlBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForInsertBatch(Connection conn, Entity ... entities) throws SQLException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (ArrayUtil.isEmpty(entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entities[0], this.dialectName());
        Set<String> fields = CollUtil.filter(entities[0].keySet(), CharSequenceUtil::isNotBlank);
        return StatementUtil.prepareStatementForBatch((Connection)var1_1, var3_3.build(), fields, (Entity[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws SQLException {
        void var2_2;
        void var1_1;
        void var3_3;
        Assert.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(query.getFirstTableName()).where((Condition[])var3_3);
        return StatementUtil.prepareStatement((Connection)var1_1, (SqlBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws SQLException {
        void var2_2;
        void var1_1;
        void var3_3;
        Assert.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepare statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where((Condition[])var3_3);
        return StatementUtil.prepareStatement((Connection)var1_1, (SqlBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForFind(Connection conn, Query query) throws SQLException {
        void var2_2;
        void var1_1;
        return this.psForPage((Connection)var1_1, (Query)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        void var2_2;
        void var3_3;
        void var1_1;
        Assert.notNull(query, "query must be not null !", new Object[0]);
        if (StrUtil.hasBlank(query.getTableNames())) {
            throw new DbRuntimeException("Table name must be not empty !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query);
        return this.psForPage((Connection)var1_1, (SqlBuilder)var3_3, var2_2.getPage());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement psForPage(Connection conn, SqlBuilder sqlBuilder, Page page) throws SQLException {
        void var2_2;
        void var1_1;
        if (page != null) {
            void var3_3;
            sqlBuilder = this.wrapPageSql(sqlBuilder.orderBy(page.getOrders()), (Page)var3_3);
        }
        return StatementUtil.prepareStatement((Connection)var1_1, (SqlBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        void var2_2;
        return find.append(" limit ").append(page.getPageSize()).append(" offset ").append(var2_2.getStartPosition());
    }

    @Override
    public String dialectName() {
        return DialectName.ANSI.name();
    }
}

