/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.db.DbUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public enum ThreadLocalConnection {
    INSTANCE;

    private final ThreadLocal<GroupedConnection> threadLocal = new ThreadLocal();

    /*
     * WARNING - void declaration
     */
    public final Connection get(DataSource ds) throws SQLException {
        void var1_1;
        void var2_2;
        GroupedConnection groupedConnection = this.threadLocal.get();
        if (groupedConnection == null) {
            groupedConnection = new GroupedConnection();
            this.threadLocal.set(groupedConnection);
        }
        return var2_2.get((DataSource)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void close(DataSource ds) {
        GroupedConnection groupedConnection = this.threadLocal.get();
        if (groupedConnection != null) {
            void var2_2;
            void var1_1;
            groupedConnection.close((DataSource)var1_1);
            if (var2_2.isEmpty()) {
                this.threadLocal.remove();
            }
        }
    }

    public static class GroupedConnection {
        private final Map<DataSource, Connection> connMap = new HashMap<DataSource, Connection>(1, 1.0f);

        /*
         * WARNING - void declaration
         */
        public Connection get(DataSource ds) throws SQLException {
            void var2_2;
            Connection conn = this.connMap.get(ds);
            if (conn == null || conn.isClosed()) {
                void var1_1;
                conn = ds.getConnection();
                this.connMap.put((DataSource)var1_1, conn);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public GroupedConnection close(DataSource ds) {
            Connection conn = this.connMap.get(ds);
            if (conn != null) {
                void var2_2;
                void var1_1;
                try {
                    if (!conn.getAutoCommit()) {
                        return this;
                    }
                }
                catch (SQLException sQLException) {}
                this.connMap.remove(var1_1);
                DbUtil.close(var2_2);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.connMap.isEmpty();
        }
    }
}

