/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.handler.HandleHelper;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.NamedSql;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlLog;
import cn.hutool.db.sql.SqlUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Wrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StatementUtil {
    /*
     * WARNING - void declaration
     */
    public static PreparedStatement fillParams(PreparedStatement ps, Object ... params) throws SQLException {
        void var1_1;
        PreparedStatement preparedStatement;
        if (ArrayUtil.isEmpty(params)) {
            return ps;
        }
        return StatementUtil.fillParams(preparedStatement, new ArrayIter((E[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params) throws SQLException {
        void var1_1;
        return StatementUtil.fillParams(ps, var1_1, null);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params, Map<Integer, Integer> nullTypeCache) throws SQLException {
        PreparedStatement preparedStatement;
        Iterator iterator;
        if (params == null) {
            return ps;
        }
        int paramIndex = 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object param = iterator.next();
            StatementUtil.setParam(ps, paramIndex++, param, nullTypeCache);
        }
        return preparedStatement;
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatement(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        void var1_1;
        return StatementUtil.prepareStatement(conn, sqlBuilder.build(), var1_1.getParamValueArray());
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatement(Connection conn, String sql, Collection<Object> params) throws SQLException {
        void var2_2;
        void var1_1;
        return StatementUtil.prepareStatement(conn, (String)var1_1, var2_2.toArray(new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        Connection connection;
        return StatementUtil.prepareStatement(GlobalDbConfig.returnGeneratedKey, connection, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatement(boolean returnGeneratedKey, Connection conn, String sql, Object ... params) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl;
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        if (ArrayUtil.isNotEmpty(params) && 1 == params.length && params[0] instanceof Map) {
            NamedSql namedSql = new NamedSql(sql, Convert.toMap(String.class, Object.class, params[0]));
            sql = namedSql.getSql();
            params = namedSql.getParams();
        }
        SqlLog.INSTANCE.log(sql, ArrayUtil.isEmpty(params) ? null : params);
        PreparedStatement ps = bl && StrUtil.startWithIgnoreCase(sql, "insert") ? conn.prepareStatement(sql, 1) : var1_1.prepareStatement((String)var2_2);
        return StatementUtil.fillParams(ps, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        void var2_2;
        void var1_1;
        return StatementUtil.prepareStatementForBatch(conn, (String)var1_1, new ArrayIter<Object[]>((E[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        AutoCloseable autoCloseable;
        Iterator iterator;
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, paramsBatch);
        AutoCloseable ps = conn.prepareStatement(sql);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object[] params = (Object[])iterator.next();
            StatementUtil.fillParams((PreparedStatement)ps, new ArrayIter((E[])var3_3), nullTypeMap);
            ps.addBatch();
        }
        return autoCloseable;
    }

    /*
     * WARNING - void declaration
     */
    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<String> fields, Entity ... entities) throws SQLException {
        AutoCloseable autoCloseable;
        void var3_3;
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.logForBatch(sql);
        AutoCloseable ps = conn.prepareStatement(sql);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        for (void entity : var3_3) {
            StatementUtil.fillParams((PreparedStatement)ps, CollUtil.valuesOfKeys(entity, fields), nullTypeMap);
            ps.addBatch();
        }
        return autoCloseable;
    }

    /*
     * WARNING - void declaration
     */
    public static CallableStatement prepareCall(Connection conn, String sql, Object ... params) throws SQLException {
        AutoCloseable autoCloseable;
        void var2_2;
        void var1_1;
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, params);
        AutoCloseable call = conn.prepareCall((String)var1_1);
        StatementUtil.fillParams((PreparedStatement)call, (Object[])var2_2);
        return autoCloseable;
    }

    public static Long getGeneratedKeyOfLong(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, rs -> {
            void var1_1;
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    ResultSet resultSet;
                    generatedKey = resultSet.getLong(1);
                }
                catch (SQLException sQLException) {}
            }
            return var1_1;
        });
    }

    public static List<Object> getGeneratedKeys(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, HandleHelper::handleRowToList);
    }

    public static <T> T getGeneratedKeys(Statement statement, RsHandler<T> rsHandler) throws SQLException {
        Object object;
        block9: {
            AutoCloseable rs2 = statement.getGeneratedKeys();
            Throwable throwable = null;
            try {
                object = object.handle((ResultSet)rs2);
                if (rs2 == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable rs2) {
                                throwable.addSuppressed(rs2);
                            }
                        } else {
                            AutoCloseable autoCloseable;
                            autoCloseable.close();
                        }
                    }
                    throw throwable3;
                }
            }
            rs2.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static int getTypeOfNull(PreparedStatement ps, int paramIndex) {
        void var2_2;
        int sqlType = 12;
        try {
            void var1_1;
            Wrapper wrapper;
            wrapper = wrapper.getParameterMetaData();
            sqlType = wrapper.getParameterType((int)var1_1);
        }
        catch (SQLException sQLException) {}
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static void setParam(PreparedStatement ps, int paramIndex, Object param) throws SQLException {
        void var2_2;
        void var1_1;
        StatementUtil.setParam(ps, (int)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void setParam(PreparedStatement ps, int paramIndex, Object param, Map<Integer, Integer> nullTypeCache) throws SQLException {
        void var2_2;
        void var1_1;
        PreparedStatement preparedStatement;
        if (param == null) {
            Integer type;
            Integer n = type = nullTypeCache == null ? null : nullTypeCache.get(paramIndex);
            if (type == null) {
                type = StatementUtil.getTypeOfNull(ps, paramIndex);
                if (nullTypeCache != null) {
                    void var3_3;
                    var3_3.put(paramIndex, type);
                }
            }
            ps.setNull(paramIndex, type);
        }
        if (param instanceof java.util.Date) {
            if (param instanceof Date) {
                ps.setDate(paramIndex, (Date)param);
                return;
            }
            if (param instanceof Time) {
                ps.setTime(paramIndex, (Time)param);
                return;
            }
            ps.setTimestamp(paramIndex, SqlUtil.toSqlTimestamp((java.util.Date)param));
            return;
        }
        if (param instanceof Number) {
            if (param instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)param);
                return;
            }
            if (param instanceof BigInteger) {
                ps.setBigDecimal(paramIndex, new BigDecimal((BigInteger)param));
                return;
            }
        }
        preparedStatement.setObject((int)var1_1, var2_2);
    }
}

