/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.db.DialectRunner;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.handler.EntityListHandler;
import cn.hutool.db.handler.HandleHelper;
import cn.hutool.db.handler.PageResultHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class SqlConnRunner
extends DialectRunner {
    private static final long serialVersionUID = 1L;

    public static SqlConnRunner create(Dialect dialect) {
        Dialect dialect2;
        return new SqlConnRunner(dialect2);
    }

    public static SqlConnRunner create(DataSource ds) {
        DataSource dataSource;
        return new SqlConnRunner(DialectFactory.getDialect(dataSource));
    }

    public static SqlConnRunner create(String driverClassName) {
        String string;
        return new SqlConnRunner(string);
    }

    /*
     * WARNING - void declaration
     */
    public SqlConnRunner(Dialect dialect) {
        super((Dialect)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SqlConnRunner(String driverClassName) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int[] insert(Connection conn, Collection<Entity> records) throws SQLException {
        void var2_2;
        void var1_1;
        return this.insert((Connection)var1_1, var2_2.toArray(new Entity[0]));
    }

    /*
     * WARNING - void declaration
     */
    public int insert(Connection conn, Entity record) throws SQLException {
        void var2_2;
        void var1_1;
        return this.insert((Connection)var1_1, new Entity[]{var2_2})[0];
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> insertForGeneratedKeys(Connection conn, Entity record) throws SQLException {
        void var2_2;
        void var1_1;
        return this.insert((Connection)var1_1, (Entity)var2_2, HandleHelper::handleRowToList);
    }

    /*
     * WARNING - void declaration
     */
    public Long insertForGeneratedKey(Connection conn, Entity record) throws SQLException {
        void var2_2;
        void var1_1;
        return this.insert((Connection)var1_1, (Entity)var2_2, (ResultSet rs) -> {
            void var1_1;
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    ResultSet resultSet;
                    generatedKey = resultSet.getLong(1);
                }
                catch (SQLException sQLException) {}
            }
            return var1_1;
        });
    }

    /*
     * WARNING - void declaration
     */
    public <T> T find(Connection conn, Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        void var2_2;
        void var3_3;
        void var1_1;
        return this.find((Connection)var1_1, Query.of((Entity)var3_3).setFields((Collection<String>)var2_2), rsh);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T find(Connection conn, Entity where, RsHandler<T> rsh, String ... fields) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.find((Connection)var1_1, (Collection<String>)CollUtil.newArrayList(fields), (Entity)var2_2, (RsHandler<T>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> find(Connection conn, Entity where) throws SQLException {
        void var2_2;
        void var1_1;
        return this.find((Connection)var1_1, where.getFieldNames(), (Entity)var2_2, new EntityListHandler(this.caseInsensitive));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findAll(Connection conn, Entity where) throws SQLException {
        void var2_2;
        void var1_1;
        return this.find((Connection)var1_1, (Entity)var2_2, new EntityListHandler(this.caseInsensitive), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findAll(Connection conn, String tableName) throws SQLException {
        void var2_2;
        void var1_1;
        return this.findAll((Connection)var1_1, Entity.create((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findBy(Connection conn, String tableName, String field, Object value) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.findAll((Connection)var1_1, Entity.create((String)var2_2).set((String)var3_3, value));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findLike(Connection conn, String tableName, String field, String value, Condition.LikeType likeType) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.findAll((Connection)var1_1, Entity.create((String)var2_2).set((String)var3_3, SqlUtil.buildLikeValue(value, likeType, true)));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findIn(Connection conn, String tableName, String field, Object ... values) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.findAll((Connection)var1_1, Entity.create((String)var2_2).set((String)var3_3, values));
    }

    /*
     * WARNING - void declaration
     */
    public long count(Connection conn, CharSequence selectSql, Object ... params) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.count((Connection)var1_1, SqlBuilder.of((CharSequence)var2_2).addParams((Object[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Connection conn, Collection<String> fields, Entity where, int pageNumber, int numPerPage, RsHandler<T> rsh) throws SQLException {
        void var2_2;
        void var3_3;
        void var1_1;
        return this.page((Connection)var1_1, Query.of((Entity)var3_3).setFields((Collection<String>)var2_2).setPage(new Page(pageNumber, numPerPage)), rsh);
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Connection conn, SqlBuilder sqlBuilder, Page page) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        PageResultHandler pageResultHandler = new PageResultHandler(new PageResult<Entity>(page.getPageNumber(), page.getPageSize(), (int)this.count(conn, sqlBuilder)), this.caseInsensitive);
        return this.page((Connection)var1_1, (SqlBuilder)var2_2, (Page)var3_3, pageResultHandler);
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.page((Connection)var1_1, (Collection<String>)var2_2, (Entity)var3_3, new Page(page, numPerPage));
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Connection conn, Entity where, Page page) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.page((Connection)var1_1, null, (Entity)var2_2, (Page)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        PageResultHandler pageResultHandler = new PageResultHandler(new PageResult<Entity>(page.getPageNumber(), page.getPageSize(), (int)this.count(conn, where)), this.caseInsensitive);
        return this.page((Connection)var1_1, (Collection<String>)var2_2, (Entity)var3_3, page, pageResultHandler);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Connection conn, Collection<String> fields, Entity where, Page page, RsHandler<T> handler) throws SQLException {
        void var2_2;
        void var3_3;
        void var1_1;
        return this.page((Connection)var1_1, Query.of((Entity)var3_3).setFields((Collection<String>)var2_2).setPage(page), handler);
    }
}

