/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.lang.func.VoidFunc1;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.AbstractDb;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.ThreadLocalConnection;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.sql.Wrapper;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;

public class Session
extends AbstractDb
implements Closeable {
    private static final long serialVersionUID = 3421251905539056945L;
    private static final Log log = LogFactory.get();

    public static Session create() {
        return new Session(DSFactory.get());
    }

    public static Session create(String group) {
        String string;
        return new Session(DSFactory.get(string));
    }

    public static Session create(DataSource ds) {
        DataSource dataSource;
        return new Session(dataSource);
    }

    /*
     * WARNING - void declaration
     */
    public Session(DataSource ds) {
        void var1_1;
        void v0 = var1_1;
        this((DataSource)v0, DialectFactory.getDialect((DataSource)v0));
    }

    /*
     * WARNING - void declaration
     */
    public Session(DataSource ds, String driverClassName) {
        this((DataSource)var1_1, DialectFactory.newDialect((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Session(DataSource ds, Dialect dialect) {
        super((DataSource)var1_1, (Dialect)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public SqlConnRunner getRunner() {
        return this.runner;
    }

    /*
     * WARNING - void declaration
     */
    public void beginTransaction() throws SQLException {
        void var1_1;
        Connection conn = ((AbstractDb)this).getConnection();
        this.checkTransactionSupported(conn);
        var1_1.setAutoCommit(false);
    }

    /*
     * WARNING - void declaration
     */
    public void commit() throws SQLException {
        try {
            ((AbstractDb)this).getConnection().commit();
        }
        catch (Throwable throwable) {
            try {
                ((AbstractDb)this).getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                void var2_3;
                log.error((Throwable)var2_3);
            }
            throw throwable;
        }
        try {
            ((AbstractDb)this).getConnection().setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            void var1_1;
            log.error((Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rollback() throws SQLException {
        try {
            ((AbstractDb)this).getConnection().rollback();
        }
        catch (Throwable throwable) {
            try {
                ((AbstractDb)this).getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                void var2_3;
                log.error((Throwable)var2_3);
            }
            throw throwable;
        }
        try {
            ((AbstractDb)this).getConnection().setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            void var1_1;
            log.error((Throwable)var1_1);
            return;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void quietRollback() {
        ((AbstractDb)this).getConnection().rollback();
        try {
            ((AbstractDb)this).getConnection().setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            log.error(e);
            return;
        }
        catch (Exception e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                try {
                    ((AbstractDb)this).getConnection().setAutoCommit(true);
                }
                catch (SQLException e2) {
                    void var2_5;
                    log.error((Throwable)var2_5);
                }
                throw throwable;
            }
            try {
                ((AbstractDb)this).getConnection().setAutoCommit(true);
                return;
            }
            catch (SQLException e3) {
                void var1_3;
                log.error((Throwable)var1_3);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            ((AbstractDb)this).getConnection().rollback(savepoint);
        }
        catch (Throwable throwable) {
            try {
                ((AbstractDb)this).getConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                void var2_4;
                log.error((Throwable)var2_4);
            }
            throw throwable;
        }
        try {
            ((AbstractDb)this).getConnection().setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            void var1_2;
            log.error((Throwable)var1_2);
            return;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void quietRollback(Savepoint savepoint) {
        ((AbstractDb)this).getConnection().rollback(savepoint);
        try {
            ((AbstractDb)this).getConnection().setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            log.error(e);
            return;
        }
        catch (Exception e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                try {
                    ((AbstractDb)this).getConnection().setAutoCommit(true);
                }
                catch (SQLException e2) {
                    void var2_6;
                    log.error((Throwable)var2_6);
                }
                throw throwable;
            }
            try {
                ((AbstractDb)this).getConnection().setAutoCommit(true);
                return;
            }
            catch (SQLException e3) {
                void var1_4;
                log.error((Throwable)var1_4);
                return;
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        return ((AbstractDb)this).getConnection().setSavepoint();
    }

    /*
     * WARNING - void declaration
     */
    public Savepoint setSavepoint(String name) throws SQLException {
        void var1_1;
        return ((AbstractDb)this).getConnection().setSavepoint((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setTransactionIsolation(int level) throws SQLException {
        void var1_1;
        if (!((AbstractDb)this).getConnection().getMetaData().supportsTransactionIsolationLevel(level)) {
            throw new SQLException(StrUtil.format("Transaction isolation [{}] not support!", level));
        }
        ((AbstractDb)this).getConnection().setTransactionIsolation((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void tx(VoidFunc1<Session> func) throws SQLException {
        try {
            this.beginTransaction();
            func.call(this);
            this.commit();
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.quietRollback();
            throw e instanceof SQLException ? (SQLException)e : new SQLException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session setWrapper(Character wrapperChar) {
        void var1_1;
        return (Session)super.setWrapper((Character)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Session setWrapper(Wrapper wrapper) {
        void var1_1;
        return (Session)super.setWrapper((Wrapper)var1_1);
    }

    @Override
    public Session disableWrapper() {
        return (Session)super.disableWrapper();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ThreadLocalConnection.INSTANCE.get(this.ds);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                return;
            }
        }
        catch (SQLException e) {
            void var1_2;
            log.error((Throwable)var1_2);
        }
        ThreadLocalConnection.INSTANCE.close(this.ds);
    }

    @Override
    public void close() {
        ((AbstractDb)this).closeConnection(null);
    }
}

