/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.sql.SqlUtil;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private Set<String> fieldNames;

    public static Entity create() {
        return new Entity();
    }

    public static Entity create(String tableName) {
        String string;
        return new Entity(string);
    }

    public static <T> Entity parse(T bean) {
        T t;
        return Entity.create(null).parseBean((Object)t);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Entity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        void var2_2;
        void var1_1;
        T t;
        return Entity.create(null).parseBean((Object)t, (boolean)var1_1, (boolean)var2_2);
    }

    public static <T> Entity parseWithUnderlineCase(T bean) {
        T t;
        return Entity.create(null).parseBean((Object)t, true, true);
    }

    public Entity() {
    }

    /*
     * WARNING - void declaration
     */
    public Entity(String tableName) {
        void var1_1;
        this.tableName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Entity(String tableName, boolean caseInsensitive) {
        super((boolean)var2_2);
        void var1_1;
        void var2_2;
        this.tableName = var1_1;
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - void declaration
     */
    public Entity setTableName(String tableName) {
        void var1_1;
        this.tableName = var1_1;
        return this;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    /*
     * WARNING - void declaration
     */
    public Entity setFieldNames(Collection<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            void var1_1;
            this.fieldNames = CollectionUtil.newHashSet(true, var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Entity setFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty(fieldNames)) {
            void var1_1;
            this.fieldNames = CollectionUtil.newLinkedHashSet(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Entity setFields(Func0<?> ... fields) {
        void var1_1;
        return (Entity)super.setFields((Func0<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Entity addFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty(fieldNames)) {
            void var1_1;
            if (this.fieldNames == null) {
                return this.setFieldNames(fieldNames);
            }
            Collections.addAll(this.fieldNames, var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Entity parseBean(T bean) {
        void var1_1;
        if (StrUtil.isBlank(this.tableName)) {
            this.setTableName(StrUtil.lowerFirst(bean.getClass().getSimpleName()));
        }
        return (Entity)super.parseBean(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Entity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (StrUtil.isBlank(this.tableName)) {
            String simpleName = bean.getClass().getSimpleName();
            this.setTableName(isToUnderlineCase ? StrUtil.toUnderlineCase(simpleName) : StrUtil.lowerFirst(simpleName));
        }
        return (Entity)super.parseBean(var1_1, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Entity filter(String ... keys) {
        void var2_2;
        void var1_1;
        Entity result = new Entity(this.tableName);
        result.setFieldNames(this.fieldNames);
        for (void key : var1_1) {
            if (!this.containsKey(key)) continue;
            result.put((String)key, this.get(key));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Entity removeNew(String ... keys) {
        void var1_1;
        return (Entity)MapUtil.removeAny(this.clone(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Entity set(String field, Object value) {
        void var2_2;
        void var1_1;
        return (Entity)super.set((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Entity setIgnoreNull(String field, Object value) {
        void var2_2;
        void var1_1;
        return (Entity)super.setIgnoreNull((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Clob getClob(String field) {
        void var1_1;
        return this.get((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public Blob getBlob(String field) {
        void var1_1;
        return this.get((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Time getTime(String field) {
        void var2_2;
        Object obj = this.get(field);
        Time result = null;
        if (obj != null) {
            try {
                result = (Time)obj;
            }
            catch (Exception exception) {
                void var1_1;
                result = (Time)ReflectUtil.invoke((Object)var1_1, "timeValue", new Object[0]);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Date getDate(String field) {
        void var2_2;
        Object obj = this.get(field);
        Date result = null;
        if (obj != null) {
            try {
                result = (Date)obj;
            }
            catch (Exception exception) {
                void var1_1;
                result = (Date)ReflectUtil.invoke((Object)var1_1, "dateValue", new Object[0]);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Timestamp getTimestamp(String field) {
        void var2_2;
        Object obj = this.get(field);
        Timestamp result = null;
        if (obj != null) {
            try {
                result = (Timestamp)obj;
            }
            catch (Exception exception) {
                void var1_1;
                result = (Timestamp)ReflectUtil.invoke((Object)var1_1, "timestampValue", new Object[0]);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getStr(String field) {
        void var1_1;
        return this.getStr((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String getStr(String field, Charset charset) {
        void var1_1;
        Object obj = this.get(field);
        if (obj instanceof Clob) {
            return SqlUtil.clobToStr((Clob)obj);
        }
        if (obj instanceof Blob) {
            return SqlUtil.blobToStr((Blob)obj, charset);
        }
        if (obj instanceof RowId) {
            void var2_2;
            void var3_3;
            field = (RowId)var3_3;
            return StrUtil.str(field.getBytes(), (Charset)var2_2);
        }
        return super.getStr((String)var1_1);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    /*
     * WARNING - void declaration
     */
    public RowId getRowId(String field) {
        void var1_1;
        Object obj = this.get(field);
        if (obj == null) {
            return null;
        }
        if (obj instanceof RowId) {
            void var2_2;
            return (RowId)var2_2;
        }
        throw new DbRuntimeException("Value of field [{}] is not a rowid!", var1_1);
    }

    @Override
    public Entity clone() {
        return (Entity)super.clone();
    }

    @Override
    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }
}

