/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.Page;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.handler.NumberHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlExecutor;
import cn.hutool.db.sql.SqlUtil;
import cn.hutool.db.sql.Wrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DialectRunner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Dialect dialect;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;

    /*
     * WARNING - void declaration
     */
    public DialectRunner(Dialect dialect) {
        void var1_1;
        this.dialect = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DialectRunner(String driverClassName) {
        this(DialectFactory.newDialect((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int[] insert(Connection conn, Entity ... records) throws SQLException {
        void var2_3;
        int[] nArray;
        PreparedStatement ps;
        block4: {
            this.checkConn((Connection)conn);
            if (ArrayUtil.isEmpty(records)) {
                return new int[]{0};
            }
            ps = null;
            try {
                if (1 != records.length) break block4;
                ps = this.dialect.psForInsert((Connection)conn, records[0]);
                conn = new int[]{ps.executeUpdate()};
            }
            catch (Throwable throwable) {
                void var3_4;
                DbUtil.close(var3_4);
                throw throwable;
            }
            DbUtil.close(ps);
            return conn;
        }
        ps = this.dialect.psForInsertBatch((Connection)nArray, (Entity[])var2_3);
        nArray = ps.executeBatch();
        DbUtil.close(ps);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public int upsert(Connection conn2, Entity record, String ... keys) throws SQLException {
        void var3_5;
        void var2_4;
        void var1_1;
        PreparedStatement ps = null;
        try {
            ps = this.getDialect().psForUpsert(conn2, record, keys);
        }
        catch (SQLException sQLException) {}
        if (ps != null) {
            try {
                int conn2 = ps.executeUpdate();
            }
            catch (Throwable conn2) {
                DbUtil.close(ps);
                throw conn2;
            }
            DbUtil.close(ps);
            return conn2;
        }
        return this.insertOrUpdate((Connection)var1_1, (Entity)var2_4, (String[])var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public int insertOrUpdate(Connection conn, Entity record, String ... keys) throws SQLException {
        void var2_2;
        void var1_1;
        Entity where = record.filter(keys);
        if (MapUtil.isNotEmpty(where) && this.count(conn, where) > 0L) {
            void var3_3;
            return this.update(conn, record.removeNew((String[])var3_3), where);
        }
        return this.insert((Connection)var1_1, new Entity[]{var2_2})[0];
    }

    /*
     * WARNING - void declaration
     */
    public <T> T insert(Connection conn, Entity record, RsHandler<T> generatedKeysHandler) throws SQLException {
        void var3_4;
        Object t;
        PreparedStatement ps;
        block4: {
            this.checkConn(conn);
            if (MapUtil.isEmpty(record)) {
                throw new SQLException("Empty entity provided!");
            }
            ps = null;
            try {
                void var2_3;
                ps = this.dialect.psForInsert((Connection)t, (Entity)var2_3);
                ps.executeUpdate();
                if (generatedKeysHandler != null) break block4;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return null;
        }
        t = StatementUtil.getGeneratedKeys(ps, var3_4);
        DbUtil.close(ps);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public int del(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty(where)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            void var2_4;
            void var1_1;
            ps = this.dialect.psForDelete((Connection)var1_1, Query.of((Entity)var2_4));
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            void var3_5;
            DbUtil.close(var3_5);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        if (MapUtil.isEmpty(where)) {
            throw new SQLException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StrUtil.isBlank(tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        Query query = new Query(SqlUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            void var3_5;
            void var2_4;
            void var1_1;
            ps = this.dialect.psForUpdate((Connection)var1_1, (Entity)var2_4, (Query)var3_5);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T find(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkConn(conn);
        Assert.notNull(query, "[query] is null !", new Object[0]);
        return SqlExecutor.queryAndClosePs(this.dialect.psForFind((Connection)var1_1, (Query)var2_2), var3_3, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public long count(Connection conn, Entity where) throws SQLException {
        void var2_2;
        void var1_1;
        this.checkConn(conn);
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount((Connection)var1_1, Query.of((Entity)var2_2)), new NumberHandler(), new Object[0]).longValue();
    }

    /*
     * WARNING - void declaration
     */
    public long count(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        void var2_2;
        void var3_3;
        void var1_1;
        this.checkConn(conn);
        String selectSql = sqlBuilder.build();
        Pattern pattern = PatternPool.get("(.*?)[\\s]order[\\s]by[\\s][^\\s]+\\s(asc|desc)?", 2);
        Matcher matcher = pattern.matcher(selectSql);
        if (matcher.matches()) {
            selectSql = matcher.group(1);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount((Connection)var1_1, SqlBuilder.of((CharSequence)var3_3).addParams(var2_2.getParamValueArray())), new NumberHandler(), new Object[0]).longValue();
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkConn(conn);
        if (null == query.getPage()) {
            return this.find(conn, query, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage((Connection)var1_1, (Query)var2_2), var3_3, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Connection conn, SqlBuilder sqlBuilder, Page page, RsHandler<T> rsh) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkConn(conn);
        if (page == null) {
            return SqlExecutor.query(conn, sqlBuilder, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage((Connection)var1_1, (SqlBuilder)var2_2, (Page)var3_3), rsh, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setCaseInsensitive(boolean caseInsensitive) {
        void var1_1;
        this.caseInsensitive = var1_1;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    /*
     * WARNING - void declaration
     */
    public void setDialect(Dialect dialect) {
        void var1_1;
        this.dialect = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWrapper(Character wrapperChar) {
        void var1_1;
        this.setWrapper(new Wrapper((Character)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setWrapper(Wrapper wrapper) {
        void var1_1;
        this.dialect.setWrapper((Wrapper)var1_1);
    }

    private void checkConn(Connection conn) {
        Assert.notNull(conn, "Connection object must be not null!", new Object[0]);
    }
}

