/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.db.Db;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.Session;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.log.Log;
import cn.hutool.log.level.Level;
import cn.hutool.setting.Setting;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class DbUtil {
    private static final Log log = Log.get();

    public static SqlConnRunner newSqlConnRunner(Dialect dialect) {
        return SqlConnRunner.create(dialect);
    }

    public static SqlConnRunner newSqlConnRunner(DataSource ds) {
        return SqlConnRunner.create(ds);
    }

    public static SqlConnRunner newSqlConnRunner(Connection conn) {
        return SqlConnRunner.create(DialectFactory.newDialect(conn));
    }

    public static Db use() {
        return Db.use();
    }

    public static Db use(DataSource ds) {
        return Db.use(ds);
    }

    /*
     * WARNING - void declaration
     */
    public static Db use(DataSource ds, Dialect dialect) {
        void var1_1;
        return Db.use(ds, (Dialect)var1_1);
    }

    public static Session newSession() {
        return Session.create(DbUtil.getDs());
    }

    public static Session newSession(DataSource ds) {
        return Session.create(ds);
    }

    /*
     * WARNING - void declaration
     */
    public static void close(Object ... objsToClose) {
        Object[] objectArray = objsToClose;
        int n = objsToClose.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            Object obj = objectArray[i];
            if (obj == null) continue;
            if (obj instanceof AutoCloseable) {
                IoUtil.close((AutoCloseable)obj);
                continue;
            }
            log.warn("Object {} not a ResultSet or Statement or PreparedStatement or Connection!", var3_3.getClass().getName());
        }
    }

    public static DataSource getDs() {
        return DSFactory.get();
    }

    public static DataSource getDs(String group) {
        return DSFactory.get(group);
    }

    /*
     * WARNING - void declaration
     */
    public static DataSource getJndiDsWithLog(String jndiName) {
        try {
            return DbUtil.getJndiDs(jndiName);
        }
        catch (DbRuntimeException e) {
            void var0_1;
            log.error(var0_1.getCause(), "Find JNDI datasource error!", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DataSource getJndiDs(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            void var0_1;
            throw new DbRuntimeException((Throwable)var0_1);
        }
    }

    public static void removeShowSqlParams(Setting setting) {
        Setting setting2;
        setting.remove("showSql");
        setting.remove("formatSql");
        setting.remove("showParams");
        setting2.remove("sqlLevel");
    }

    /*
     * WARNING - void declaration
     */
    public static void setShowSqlGlobal(Setting setting) {
        Level level;
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isShowSql = Convert.toBool(setting.remove("showSql"), Boolean.FALSE);
        boolean isFormatSql = Convert.toBool(setting.remove("formatSql"), Boolean.FALSE);
        boolean isShowParams = Convert.toBool(setting.remove("showParams"), Boolean.FALSE);
        Level sqlLevelStr = setting.remove("sqlLevel");
        if (sqlLevelStr != null) {
            sqlLevelStr = ((String)((Object)sqlLevelStr)).toUpperCase();
        }
        Level level2 = Convert.toEnum(Level.class, (Object)sqlLevelStr, Level.DEBUG);
        log.debug("Show sql: [{}], format sql: [{}], show params: [{}], level: [{}]", new Object[]{isShowSql, isFormatSql, isShowParams, level2});
        DbUtil.setShowSqlGlobal((boolean)var1_1, (boolean)var2_2, (boolean)var3_3, level);
    }

    /*
     * WARNING - void declaration
     */
    public static void setShowSqlGlobal(boolean isShowSql, boolean isFormatSql, boolean isShowParams, Level level) {
        void var3_3;
        void var2_2;
        void var1_1;
        GlobalDbConfig.setShowSql(isShowSql, (boolean)var1_1, (boolean)var2_2, (Level)var3_3);
    }

    public static void setCaseInsensitiveGlobal(boolean caseInsensitive) {
        GlobalDbConfig.setCaseInsensitive(caseInsensitive);
    }

    public static void setReturnGeneratedKeyGlobal(boolean returnGeneratedKey) {
        GlobalDbConfig.setReturnGeneratedKey(returnGeneratedKey);
    }

    public static void setDbSettingPathGlobal(String dbSettingPath) {
        GlobalDbConfig.setDbSettingPath(dbSettingPath);
    }
}

