/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.lang.func.VoidFunc1;
import cn.hutool.db.AbstractDb;
import cn.hutool.db.ThreadLocalConnection;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.sql.Wrapper;
import cn.hutool.db.transaction.TransactionLevel;
import cn.hutool.log.StaticLog;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class Db
extends AbstractDb {
    private static final long serialVersionUID = -3378415769645309514L;

    public static Db use() {
        return Db.use(DSFactory.get());
    }

    public static Db use(String group) {
        return Db.use(DSFactory.get(group));
    }

    public static Db use(DataSource ds) {
        DataSource dataSource;
        if (ds == null) {
            return null;
        }
        return new Db(dataSource);
    }

    /*
     * WARNING - void declaration
     */
    public static Db use(DataSource ds, Dialect dialect) {
        void var1_1;
        DataSource dataSource;
        return new Db(dataSource, (Dialect)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Db use(DataSource ds, String driverClassName) {
        void var1_1;
        DataSource dataSource;
        return new Db(dataSource, DialectFactory.newDialect((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Db(DataSource ds) {
        void var1_1;
        void v0 = var1_1;
        this((DataSource)v0, DialectFactory.getDialect((DataSource)v0));
    }

    /*
     * WARNING - void declaration
     */
    public Db(DataSource ds, String driverClassName) {
        this((DataSource)var1_1, DialectFactory.newDialect((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Db(DataSource ds, Dialect dialect) {
        super((DataSource)var1_1, (Dialect)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Db setWrapper(Character wrapperChar) {
        void var1_1;
        return (Db)super.setWrapper((Character)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Db setWrapper(Wrapper wrapper) {
        void var1_1;
        return (Db)super.setWrapper((Wrapper)var1_1);
    }

    @Override
    public Db disableWrapper() {
        return (Db)super.disableWrapper();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ThreadLocalConnection.INSTANCE.get(this.ds);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(Connection conn) {
        try {
            void var1_1;
            if (conn != null && !var1_1.getAutoCommit()) {
                return;
            }
        }
        catch (SQLException sQLException) {}
        ThreadLocalConnection.INSTANCE.close(this.ds);
    }

    /*
     * WARNING - void declaration
     */
    public Db tx(VoidFunc1<Db> func) throws SQLException {
        void var1_1;
        return this.tx(null, (VoidFunc1<Db>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Db tx(TransactionLevel transactionLevel, VoidFunc1<Db> func) throws SQLException {
        boolean autoCommit;
        Connection conn = ((AbstractDb)this).getConnection();
        this.checkTransactionSupported(conn);
        if (transactionLevel != null) {
            int level = transactionLevel.getLevel();
            if (conn.getTransactionIsolation() < level) {
                conn.setTransactionIsolation(level);
            }
        }
        if (autoCommit = conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        try {
            func.call(this);
            conn.commit();
            this.quietSetAutoCommit(conn, autoCommit);
            ((AbstractDb)this).closeConnection(conn);
        }
        catch (Throwable e) {
            try {
                void var2_5;
                this.quietRollback(conn);
                throw e instanceof SQLException ? (SQLException)e : new SQLException((Throwable)var2_5);
            }
            catch (Throwable throwable) {
                void var3_7;
                void var1_3;
                this.quietSetAutoCommit(conn, (boolean)var1_3);
                ((AbstractDb)this).closeConnection((Connection)var3_7);
                throw throwable;
            }
        }
        return this;
    }

    private void quietRollback(Connection conn) {
        if (conn != null) {
            Exception exception;
            try {
                exception.rollback();
                return;
            }
            catch (Exception exception2) {
                exception = exception2;
                StaticLog.error(exception2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void quietSetAutoCommit(Connection conn, Boolean autoCommit) {
        if (conn != null && autoCommit != null) {
            Exception exception;
            try {
                void var2_2;
                exception.setAutoCommit(var2_2.booleanValue());
                return;
            }
            catch (Exception exception2) {
                exception = exception2;
                StaticLog.error(exception2);
            }
        }
    }
}

