/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.ds.DSFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;

public class DaoTemplate {
    protected String tableName;
    protected String primaryKeyField = "id";
    protected Db db;

    /*
     * WARNING - void declaration
     */
    public DaoTemplate(String tableName) {
        this((String)var1_1, (String)null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DaoTemplate(String tableName, String primaryKeyField) {
        this((String)var1_1, (String)var2_2, DSFactory.get());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DaoTemplate(String tableName, DataSource ds) {
        this((String)var1_1, null, (DataSource)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DaoTemplate(String tableName, String primaryKeyField, DataSource ds) {
        this((String)var1_1, (String)var2_2, Db.use((DataSource)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DaoTemplate(String tableName, String primaryKeyField, Db db) {
        void var3_3;
        void var1_1;
        this.tableName = var1_1;
        if (StrUtil.isNotBlank(primaryKeyField)) {
            void var2_2;
            this.primaryKeyField = var2_2;
        }
        this.db = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int add(Entity entity) throws SQLException {
        void var1_1;
        return this.db.insert(this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> addForGeneratedKeys(Entity entity) throws SQLException {
        void var1_1;
        return this.db.insertForGeneratedKeys(this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Long addForGeneratedKey(Entity entity) throws SQLException {
        void var1_1;
        return this.db.insertForGeneratedKey(this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public <T> int del(T pk) throws SQLException {
        void var1_1;
        if (pk == null) {
            return 0;
        }
        DaoTemplate daoTemplate = this;
        return daoTemplate.del(Entity.create(daoTemplate.tableName).set(this.primaryKeyField, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public <T> int del(String field, T value) throws SQLException {
        void var2_2;
        void var1_1;
        if (StrUtil.isBlank(field)) {
            return 0;
        }
        DaoTemplate daoTemplate = this;
        return daoTemplate.del(Entity.create(daoTemplate.tableName).set((String)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <T> int del(Entity where) throws SQLException {
        void var1_1;
        if (MapUtil.isEmpty(where)) {
            return 0;
        }
        return this.db.del(this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int update(Entity record, Entity where) throws SQLException {
        void var2_2;
        void var1_1;
        if (MapUtil.isEmpty(record)) {
            return 0;
        }
        return this.db.update(this.fixEntity((Entity)var1_1), (Entity)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int update(Entity entity) throws SQLException {
        void var2_2;
        void var1_1;
        if (MapUtil.isEmpty(entity)) {
            return 0;
        }
        Object pk = (entity = this.fixEntity(entity)).get(this.primaryKeyField);
        if (pk == null) {
            throw new SQLException(StrUtil.format("Please determine `{}` for update", this.primaryKeyField));
        }
        Entity where = Entity.create(this.tableName).set(this.primaryKeyField, pk);
        Entity record = entity.clone();
        record.remove(this.primaryKeyField);
        return this.db.update((Entity)var1_1, (Entity)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int addOrUpdate(Entity entity) throws SQLException {
        void var1_1;
        if (null == entity.get(this.primaryKeyField)) {
            return this.add(entity);
        }
        return this.update((Entity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> Entity get(T pk) throws SQLException {
        void var1_1;
        DaoTemplate daoTemplate = this;
        return daoTemplate.get(daoTemplate.primaryKeyField, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> Entity get(String field, T value) throws SQLException {
        void var2_2;
        void var1_1;
        DaoTemplate daoTemplate = this;
        return daoTemplate.get(Entity.create(daoTemplate.tableName).set((String)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Entity get(Entity where) throws SQLException {
        void var1_1;
        return this.db.get(this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<Entity> find(String field, T value) throws SQLException {
        void var2_2;
        void var1_1;
        DaoTemplate daoTemplate = this;
        return daoTemplate.find(Entity.create(daoTemplate.tableName).set((String)var1_1, var2_2));
    }

    public List<Entity> findAll() throws SQLException {
        DaoTemplate daoTemplate = this;
        return daoTemplate.find(Entity.create(daoTemplate.tableName));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> find(Entity where) throws SQLException {
        void var1_1;
        return this.db.find(null, this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findBySql(String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        void var3_3;
        String selectKeyword = StrUtil.subPre(sql.trim(), 6).toLowerCase();
        if (!"select".equals(var3_3)) {
            sql = "SELECT * FROM " + this.tableName + " " + sql;
        }
        return this.db.query((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Entity where, Page page, String ... selectFields) throws SQLException {
        void var2_2;
        void var1_1;
        void var3_3;
        return this.db.page(Arrays.asList(var3_3), this.fixEntity((Entity)var1_1), (Page)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        void var2_2;
        void var1_1;
        return this.db.page(this.fixEntity((Entity)var1_1), (Page)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public long count(Entity where) throws SQLException {
        void var1_1;
        return this.db.count(this.fixEntity((Entity)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean exist(Entity where) throws SQLException {
        void var1_1;
        return this.count((Entity)var1_1) > 0L;
    }

    /*
     * WARNING - void declaration
     */
    private Entity fixEntity(Entity entity) {
        void var1_1;
        if (entity == null) {
            entity = Entity.create(this.tableName);
        } else if (StrUtil.isBlank(entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return var1_1;
    }
}

