/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.handler.BeanListHandler;
import cn.hutool.db.handler.EntityHandler;
import cn.hutool.db.handler.EntityListHandler;
import cn.hutool.db.handler.HandleHelper;
import cn.hutool.db.handler.NumberHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.handler.StringHandler;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlExecutor;
import cn.hutool.db.sql.SqlUtil;
import cn.hutool.db.sql.Wrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractDb
implements Serializable {
    private static final long serialVersionUID = 3858951941916349062L;
    protected final DataSource ds;
    protected Boolean isSupportTransaction = null;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;
    protected SqlConnRunner runner;

    /*
     * WARNING - void declaration
     */
    public AbstractDb(DataSource ds, Dialect dialect) {
        void var2_2;
        void var1_1;
        this.ds = var1_1;
        this.runner = new SqlConnRunner((Dialect)var2_2);
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract void closeConnection(Connection var1);

    /*
     * WARNING - void declaration
     */
    public List<Entity> query(String sql, Map<String, Object> params) throws SQLException {
        void var2_2;
        void var1_1;
        return this.query((String)var1_1, new EntityListHandler(this.caseInsensitive), (Map<String, Object>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> query(String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        return this.query((String)var1_1, new EntityListHandler(this.caseInsensitive), (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> query(String sql, Class<T> beanClass, Object ... params) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return (List)this.query((String)var1_1, new BeanListHandler(var2_2), (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Entity queryOne(String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        return this.query((String)var1_1, new EntityHandler(this.caseInsensitive), (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Number queryNumber(String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        return this.query((String)var1_1, new NumberHandler(), (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String queryString(String sql, Object ... params) throws SQLException {
        void var2_2;
        void var1_1;
        return this.query((String)var1_1, new StringHandler(), (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            Object t;
            conn = this.getConnection();
            t = SqlExecutor.query(conn, (String)t, var2_3, (Object[])var3_4);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T query(String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            Object t;
            conn = this.getConnection();
            t = SqlExecutor.query(conn, (String)t, var2_3, (Map<String, Object>)var3_4);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T query(Func1<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws SQLException {
        Object t;
        Connection conn = null;
        try {
            void var2_3;
            conn = this.getConnection();
            t = SqlExecutor.query(conn, (Func1<Connection, PreparedStatement>)t, var2_3);
            this.closeConnection(conn);
        }
        catch (Throwable throwable) {
            void var3_4;
            this.closeConnection((Connection)var3_4);
            throw throwable;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public int execute(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            void var2_4;
            void var1_1;
            conn = this.getConnection();
            int n = SqlExecutor.execute(conn, (String)var1_1, (Object[])var2_4);
            this.closeConnection(conn);
            return n;
        }
        catch (Throwable throwable) {
            void var3_5;
            this.closeConnection((Connection)var3_5);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            void var2_3;
            Long l;
            conn = this.getConnection();
            l = SqlExecutor.executeForGeneratedKey(conn, (String)((Object)l), (Object[])var2_3);
            this.closeConnection(conn);
            return l;
        }
        catch (Throwable throwable) {
            void var3_4;
            this.closeConnection((Connection)var3_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        Connection conn = null;
        try {
            void var2_3;
            int[] nArray;
            conn = this.getConnection();
            nArray = SqlExecutor.executeBatch(conn, (String)nArray, (Object[][])var2_3);
            this.closeConnection(conn);
            return nArray;
        }
        catch (Throwable throwable) {
            void var3_4;
            this.closeConnection((Connection)var3_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int[] executeBatch(String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        Connection conn = null;
        try {
            void var2_3;
            int[] nArray;
            conn = this.getConnection();
            nArray = SqlExecutor.executeBatch(conn, (String)nArray, (Iterable<Object[]>)var2_3);
            this.closeConnection(conn);
            return nArray;
        }
        catch (Throwable throwable) {
            void var3_4;
            this.closeConnection((Connection)var3_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int[] executeBatch(String ... sqls) throws SQLException {
        Connection conn = null;
        try {
            int[] nArray;
            conn = this.getConnection();
            nArray = SqlExecutor.executeBatch(conn, (String[])nArray);
            this.closeConnection(conn);
            return nArray;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int[] executeBatch(Iterable<String> sqls) throws SQLException {
        Connection conn = null;
        try {
            int[] nArray;
            conn = this.getConnection();
            nArray = SqlExecutor.executeBatch(conn, (Iterable<String>)nArray);
            this.closeConnection(conn);
            return nArray;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int insert(Entity record) throws SQLException {
        Connection conn = null;
        try {
            void var1_1;
            conn = this.getConnection();
            int n = this.runner.insert(conn, (Entity)var1_1);
            this.closeConnection(conn);
            return n;
        }
        catch (Throwable throwable) {
            void var2_4;
            this.closeConnection((Connection)var2_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int insertOrUpdate(Entity record, String ... keys) throws SQLException {
        Connection conn = null;
        try {
            void var2_4;
            void var1_1;
            conn = this.getConnection();
            int n = this.runner.insertOrUpdate(conn, (Entity)var1_1, (String[])var2_4);
            this.closeConnection(conn);
            return n;
        }
        catch (Throwable throwable) {
            void var3_5;
            this.closeConnection((Connection)var3_5);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int upsert(Entity record, String ... keys) throws SQLException {
        Connection conn = null;
        try {
            void var2_4;
            void var1_1;
            conn = this.getConnection();
            int n = this.runner.upsert(conn, (Entity)var1_1, (String[])var2_4);
            this.closeConnection(conn);
            return n;
        }
        catch (Throwable throwable) {
            void var3_5;
            this.closeConnection((Connection)var3_5);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int[] insert(Collection<Entity> records) throws SQLException {
        Connection conn = null;
        try {
            int[] nArray;
            conn = this.getConnection();
            nArray = this.runner.insert(conn, (Collection<Entity>)nArray);
            this.closeConnection(conn);
            return nArray;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> insertForGeneratedKeys(Entity record) throws SQLException {
        Connection conn = null;
        try {
            List<Object> list;
            conn = this.getConnection();
            list = this.runner.insertForGeneratedKeys(conn, (Entity)((Object)list));
            this.closeConnection(conn);
            return list;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Long insertForGeneratedKey(Entity record) throws SQLException {
        Connection conn = null;
        try {
            Long l;
            conn = this.getConnection();
            l = this.runner.insertForGeneratedKey(conn, (Entity)((Object)l));
            this.closeConnection(conn);
            return l;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int del(String tableName, String field, Object value) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.del(Entity.create((String)var1_1).set((String)var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public int del(Entity where) throws SQLException {
        Connection conn = null;
        try {
            void var1_1;
            conn = this.getConnection();
            int n = this.runner.del(conn, (Entity)var1_1);
            this.closeConnection(conn);
            return n;
        }
        catch (Throwable throwable) {
            void var2_4;
            this.closeConnection((Connection)var2_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int update(Entity record, Entity where) throws SQLException {
        Connection conn = null;
        try {
            void var2_4;
            void var1_1;
            conn = this.getConnection();
            int n = this.runner.update(conn, (Entity)var1_1, (Entity)var2_4);
            this.closeConnection(conn);
            return n;
        }
        catch (Throwable throwable) {
            void var3_5;
            this.closeConnection((Connection)var3_5);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> Entity get(String tableName, String field, T value) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.get(Entity.create((String)var1_1).set((String)var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Entity get(Entity where) throws SQLException {
        void var1_1;
        return this.find(where.getFieldNames(), (Entity)var1_1, new EntityHandler(this.caseInsensitive));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            Object t;
            conn = this.getConnection();
            t = this.runner.find(conn, (Collection<String>)t, (Entity)var2_3, var3_4);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> find(Collection<String> fields, Entity where) throws SQLException {
        void var2_2;
        void var1_1;
        return this.find((Collection<String>)var1_1, (Entity)var2_2, new EntityListHandler(this.caseInsensitive));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T find(Query query, RsHandler<T> rsh) throws SQLException {
        Object t;
        Connection conn = null;
        try {
            void var2_3;
            conn = this.getConnection();
            t = this.runner.find(conn, (Query)t, var2_3);
            this.closeConnection(conn);
        }
        catch (Throwable throwable) {
            void var3_4;
            this.closeConnection((Connection)var3_4);
            throw throwable;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T find(Entity where, RsHandler<T> rsh, String ... fields) throws SQLException {
        void var2_2;
        void var1_1;
        void var3_3;
        return this.find((Collection<String>)CollUtil.newArrayList(var3_3), (Entity)var1_1, (RsHandler<T>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> find(Entity where) throws SQLException {
        void var1_1;
        return this.find(where.getFieldNames(), (Entity)var1_1, new EntityListHandler(this.caseInsensitive));
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> find(Entity where, Class<T> beanClass) throws SQLException {
        void var2_2;
        void var1_1;
        return (List)this.find(where.getFieldNames(), (Entity)var1_1, BeanListHandler.create(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findAll(Entity where) throws SQLException {
        void var1_1;
        return this.find((Entity)var1_1, new EntityListHandler(this.caseInsensitive), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> findAll(Entity where, Class<T> beanClass) throws SQLException {
        void var2_2;
        void var1_1;
        return (List)this.find((Entity)var1_1, BeanListHandler.create(var2_2), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findAll(String tableName) throws SQLException {
        void var1_1;
        return this.findAll(Entity.create((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findBy(String tableName, String field, Object value) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.findAll(Entity.create((String)var1_1).set((String)var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findBy(String tableName, Condition ... wheres) throws SQLException {
        void var1_1;
        void var2_2;
        Query query = new Query((Condition[])var2_2, tableName);
        return this.find((Query)var1_1, new EntityListHandler(this.caseInsensitive));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> findLike(String tableName, String field, String value, Condition.LikeType likeType) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.findAll(Entity.create((String)var1_1).set((String)var2_2, SqlUtil.buildLikeValue((String)var3_3, likeType, true)));
    }

    /*
     * WARNING - void declaration
     */
    public long count(Entity where) throws SQLException {
        Connection conn = null;
        try {
            void var1_1;
            conn = this.getConnection();
            long l = this.runner.count(conn, (Entity)var1_1);
            this.closeConnection(conn);
            return l;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long count(SqlBuilder sql) throws SQLException {
        Connection conn = null;
        try {
            void var1_1;
            conn = this.getConnection();
            long l = this.runner.count(conn, (SqlBuilder)var1_1);
            this.closeConnection(conn);
            return l;
        }
        catch (Throwable throwable) {
            void var2_3;
            this.closeConnection((Connection)var2_3);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long count(CharSequence selectSql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            void var2_3;
            void var1_1;
            conn = this.getConnection();
            long l = this.runner.count(conn, (CharSequence)var1_1, (Object[])var2_3);
            this.closeConnection(conn);
            return l;
        }
        catch (Throwable throwable) {
            void var3_4;
            this.closeConnection((Connection)var3_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            T t;
            conn = this.getConnection();
            t = this.runner.page(conn, (Collection<String>)t, (Entity)var2_3, (int)var3_4, numPerPage, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.page((Entity)var1_1, new Page((int)var2_2, (int)var3_3), rsh);
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> pageForEntityList(Entity where, int page, int numPerPage) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.pageForEntityList((Entity)var1_1, new Page((int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public List<Entity> pageForEntityList(Entity where, Page page) throws SQLException {
        void var2_2;
        void var1_1;
        return this.page((Entity)var1_1, (Page)var2_2, new EntityListHandler(this.caseInsensitive));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.page((Collection<String>)where.getFieldNames(), (Entity)var1_1, (Page)var2_2, (RsHandler<T>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            T t;
            conn = this.getConnection();
            t = this.runner.page(conn, (Collection<String>)t, (Entity)var2_3, (Page)var3_4, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(CharSequence sql, Page page, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            Object t;
            conn = this.getConnection();
            t = this.runner.page(conn, SqlBuilder.of((CharSequence)t).addParams(params), (Page)var2_3, var3_4);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> PageResult<T> page(CharSequence sql, Page page, Class<T> elementBeanType, Object ... params) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        PageResult result = new PageResult(page.getPageNumber(), page.getPageSize(), (int)this.count(sql, params));
        return this.page((CharSequence)var1_1, (Page)var2_2, arg_0 -> AbstractDb.lambda$page$e33ee6c3$1(result, (Class)var3_3, arg_0), params);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T page(SqlBuilder sql, Page page, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            Object t;
            conn = this.getConnection();
            t = this.runner.page(conn, (SqlBuilder)t, (Page)var2_3, var3_4);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(CharSequence sql, Page page, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            void var2_3;
            void var3_4;
            PageResult<Entity> pageResult;
            conn = this.getConnection();
            pageResult = this.runner.page(conn, SqlBuilder.of((CharSequence)((Object)pageResult)).addParams((Object[])var3_4), (Page)var2_3);
            return pageResult;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Collection<String> fields, Entity where, int pageNumber, int pageSize) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.page((Collection<String>)var1_1, (Entity)var2_2, new Page((int)var3_3, pageSize));
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Collection<String> fields, Entity where, Page page) throws SQLException {
        Connection conn = null;
        try {
            void var3_4;
            void var2_3;
            PageResult<Entity> pageResult;
            conn = this.getConnection();
            pageResult = this.runner.page(conn, (Collection<String>)pageResult, (Entity)var2_3, (Page)var3_4);
            return pageResult;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Entity where, int page, int numPerPage) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.page((Entity)var1_1, new Page((int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        void var2_2;
        void var1_1;
        return this.page(where.getFieldNames(), (Entity)var1_1, (Page)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setCaseInsensitive(boolean caseInsensitive) {
        void var1_1;
        this.caseInsensitive = var1_1;
    }

    public SqlConnRunner getRunner() {
        return this.runner;
    }

    /*
     * WARNING - void declaration
     */
    public void setRunner(SqlConnRunner runner) {
        void var1_1;
        this.runner = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractDb setWrapper(Character wrapperChar) {
        void var1_1;
        return this.setWrapper(new Wrapper((Character)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public AbstractDb setWrapper(Wrapper wrapper) {
        void var1_1;
        this.runner.setWrapper((Wrapper)var1_1);
        return this;
    }

    public AbstractDb disableWrapper() {
        return this.setWrapper((Wrapper)null);
    }

    /*
     * WARNING - void declaration
     */
    protected void checkTransactionSupported(Connection conn) throws SQLException, DbRuntimeException {
        if (this.isSupportTransaction == null) {
            void var1_1;
            this.isSupportTransaction = var1_1.getMetaData().supportsTransactions();
        }
        if (!this.isSupportTransaction.booleanValue()) {
            throw new DbRuntimeException("Transaction not supported for current database!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ PageResult lambda$page$e33ee6c3$1(PageResult result, Class elementBeanType, ResultSet rs) throws SQLException {
        void var1_1;
        PageResult pageResult;
        return HandleHelper.handleRsToBeanList(rs, pageResult, var1_1);
    }
}

