/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric.fpe;

import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.jcajce.spec.FPEParameterSpec;

public class FPE
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AES aes;
    private final AlphabetMapper mapper;

    /*
     * WARNING - void declaration
     */
    public FPE(FPEMode mode, byte[] key, AlphabetMapper mapper) {
        this((FPEMode)var1_1, (byte[])var2_2, (AlphabetMapper)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FPE(FPEMode mode, byte[] key, AlphabetMapper mapper, byte[] tweak) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (mode == null) {
            mode = FPEMode.FF1;
        }
        if (tweak == null) {
            switch (mode) {
                case FF1: {
                    tweak = new byte[]{};
                    break;
                }
                case FF3_1: {
                    tweak = new byte[7];
                }
            }
        }
        this.aes = new AES(mode.value, Padding.NoPadding.name(), KeyUtil.generateKey(((FPEMode)var1_1).value, (byte[])var2_2), (AlgorithmParameterSpec)new FPEParameterSpec(mapper.getRadix(), tweak));
        this.mapper = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String encrypt(String data) {
        void var1_1;
        if (data == null) {
            return null;
        }
        return new String(this.encrypt(var1_1.toCharArray()));
    }

    /*
     * WARNING - void declaration
     */
    public char[] encrypt(char[] data) {
        void var1_1;
        if (data == null) {
            return null;
        }
        return this.mapper.convertToChars(this.aes.encrypt(this.mapper.convertToIndexes((char[])var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public String decrypt(String data) {
        void var1_1;
        if (data == null) {
            return null;
        }
        return new String(this.decrypt(var1_1.toCharArray()));
    }

    /*
     * WARNING - void declaration
     */
    public char[] decrypt(char[] data) {
        void var1_1;
        if (data == null) {
            return null;
        }
        return this.mapper.convertToChars(this.aes.decrypt(this.mapper.convertToIndexes((char[])var1_1)));
    }

    public static enum FPEMode {
        FF1("FF1"),
        FF3_1("FF3-1");

        private final String value;

        /*
         * WARNING - void declaration
         */
        private FPEMode(String name) {
            void var3_3;
            this.value = var3_3;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

