/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CipherMode;
import cn.hutool.crypto.CipherWrapper;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricDecryptor;
import cn.hutool.crypto.symmetric.SymmetricEncryptor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto
implements SymmetricDecryptor,
SymmetricEncryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private CipherWrapper cipherWrapper;
    private SecretKey secretKey;
    private boolean isZeroPadding;
    private final Lock lock;

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this((SymmetricAlgorithm)var1_1, (byte[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(String algorithm) {
        this((String)var1_1, (byte[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(var1_1.getValue(), (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(var1_1.getValue(), (SecretKey)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(String algorithm, byte[] key) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((String)v0, KeyUtil.generateKey((String)v0, (byte[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(String algorithm, SecretKey key) {
        this((String)var1_1, (SecretKey)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.lock = new ReentrantLock();
        this.init(algorithm, (SecretKey)var2_2);
        this.initParams((String)var1_1, (AlgorithmParameterSpec)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto init(String algorithm, SecretKey key) {
        void var1_1;
        void var2_2;
        Assert.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = var2_2;
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StrUtil.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipherWrapper = new CipherWrapper((String)var1_1);
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipherWrapper.getCipher();
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        void var1_1;
        this.cipherWrapper.setParams((AlgorithmParameterSpec)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto setIv(IvParameterSpec iv) {
        void var1_1;
        return this.setParams((AlgorithmParameterSpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto setIv(byte[] iv) {
        void var1_1;
        return this.setIv(new IvParameterSpec((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto setRandom(SecureRandom random) {
        void var1_1;
        this.cipherWrapper.setRandom((SecureRandom)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCrypto setMode(CipherMode mode) {
        this.lock.lock();
        try {
            this.initMode(mode.getValue());
        }
        catch (Exception e) {
            void var1_2;
            throw new CryptoException((Throwable)var1_2);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] update(byte[] data) {
        Cipher cipher = this.cipherWrapper.getCipher();
        this.lock.lock();
        try {
            void var2_4;
            data = cipher.update(this.paddingDataWithZero(data, var2_4.getBlockSize()));
            return data;
        }
        catch (Exception e) {
            void var1_2;
            throw new CryptoException((Throwable)var1_2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String updateHex(byte[] data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.update((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            byte[] byArray;
            Cipher cipher = this.initMode(1);
            byArray = cipher.doFinal(this.paddingDataWithZero(byArray, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            void var2_4;
            throw new CryptoException((Throwable)var2_4);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initMode(1);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IoUtil.copy(data, cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                void var2_3;
                cipherOutputStream.write(new byte[var2_3 - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (IORuntimeException iORuntimeException) {
            try {
                IORuntimeException remainLength = iORuntimeException;
                throw iORuntimeException;
                catch (Exception e) {
                    throw new CryptoException(e);
                }
            }
            catch (Throwable throwable) {
                void var3_5;
                this.lock.unlock();
                IoUtil.close(cipherOutputStream);
                if (var3_5 != false) {
                    void var1_1;
                    IoUtil.close((Closeable)var1_1);
                }
                throw throwable;
            }
        }
        this.lock.unlock();
        IoUtil.close(cipherOutputStream);
        if (isClose) {
            IoUtil.close(data);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decrypt(byte[] bytes) {
        void var2_5;
        void var1_1;
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(2);
            int blockSize = cipher.getBlockSize();
            byte[] decryptData = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            void var3_4;
            throw new CryptoException((Throwable)var3_4);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding((byte[])var1_1, (int)var2_5);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        CipherInputStream cipherInputStream;
        block10: {
            int blockSize;
            this.lock.lock();
            cipherInputStream = null;
            Cipher cipher = this.initMode(2);
            cipherInputStream = new CipherInputStream(data, cipher);
            if (!this.isZeroPadding || (blockSize = cipher.getBlockSize()) <= 0) break block10;
            SymmetricCrypto.copyForZeroPadding(cipherInputStream, out, blockSize);
            this.lock.unlock();
            IoUtil.close(cipherInputStream);
            if (!isClose) return;
            IoUtil.close(data);
            return;
        }
        try {
            void var2_2;
            IoUtil.copy(cipherInputStream, (OutputStream)var2_2);
        }
        catch (IOException e222222) {
            try {
                throw new IORuntimeException(e222222);
                catch (IORuntimeException iORuntimeException) {
                    IORuntimeException e222222 = iORuntimeException;
                    throw iORuntimeException;
                }
                catch (Exception e3) {
                    throw new CryptoException(e3);
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                void var3_4;
                this.lock.unlock();
                IoUtil.close(cipherInputStream);
                if (var3_4 == false) throw throwable;
                IoUtil.close((Closeable)var1_1);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoUtil.close(cipherInputStream);
        if (!isClose) return;
        IoUtil.close(data);
        return;
    }

    /*
     * WARNING - void declaration
     */
    private SymmetricCrypto initParams(String algorithm, AlgorithmParameterSpec paramsSpec) {
        void var2_2;
        if (paramsSpec == null) {
            void var1_1;
            byte[] iv = Opt.ofNullable(this.cipherWrapper).map(CipherWrapper::getCipher).map(Cipher::getIV).get();
            if (StrUtil.startWithIgnoreCase(algorithm, "PBE")) {
                if (iv == null) {
                    iv = RandomUtil.randomBytes(8);
                }
                paramsSpec = new PBEParameterSpec(iv, 100);
            } else if (StrUtil.startWithIgnoreCase((CharSequence)var1_1, "AES") && iv != null) {
                void var3_3;
                paramsSpec = new IvParameterSpec((byte[])var3_3);
            }
        }
        return this.setParams((AlgorithmParameterSpec)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Cipher initMode(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var1_1;
        return this.cipherWrapper.initMode((int)var1_1, this.secretKey).getCipher();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        void var1_1;
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            void var2_2;
            void var3_3;
            return ArrayUtil.resize(data, (int)(var3_3 + var2_2 - remainLength));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] removePadding(byte[] data, int blockSize) {
        void var1_1;
        int length;
        if (this.isZeroPadding && blockSize > 0 && (blockSize = (length = data.length) % blockSize) == 0) {
            void var2_2;
            for (void i = var3_3 - true; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize(data, (int)(var2_2 + true));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        void var1_1;
        void var3_5;
        int i;
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(1, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            ArrayUtil.copy(buffer, preBuffer, readSize);
            preReadSize = readSize;
        }
        for (i = preReadSize - 1; i >= 0 && 0 == preBuffer[i]; --i) {
        }
        out.write((byte[])var3_5, 0, i + 1);
        var1_1.flush();
    }
}

