/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RC4
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SBOX_LENGTH = 256;
    private static final int KEY_MIN_LENGTH = 5;
    private int[] sbox;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - void declaration
     */
    public RC4(String key) throws CryptoException {
        void var1_1;
        this.setKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encrypt(String message, Charset charset) throws CryptoException {
        void var2_2;
        void var1_1;
        return this.crypt(StrUtil.bytes((CharSequence)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encrypt(String message) throws CryptoException {
        void var1_1;
        return this.encrypt((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String encryptHex(byte[] data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.crypt((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String encryptBase64(byte[] data) {
        void var1_1;
        return Base64.encode(this.crypt((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String encryptHex(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.encrypt((String)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String encryptHex(String data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.encrypt((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String encryptBase64(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return Base64.encode(this.encrypt((String)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String encryptBase64(String data) {
        void var1_1;
        return Base64.encode(this.encrypt((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String decrypt(byte[] message, Charset charset) throws CryptoException {
        void var2_2;
        void var1_1;
        return StrUtil.str(this.crypt((byte[])var1_1), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String decrypt(byte[] message) throws CryptoException {
        void var1_1;
        return this.decrypt((byte[])var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String decrypt(String message) {
        void var1_1;
        return this.decrypt(SecureUtil.decode((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String decrypt(String message, Charset charset) {
        void var2_2;
        void var1_1;
        return StrUtil.str((Object)this.decrypt((String)var1_1), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] crypt(byte[] msg) {
        void var3_5;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int[] sbox = (int[])this.sbox.clone();
            byte[] code = new byte[msg.length];
            int i = 0;
            int j = 0;
            for (int n = 0; n < msg.length; ++n) {
                i = (i + 1) % 256;
                j = (j + sbox[i]) % 256;
                this.swap(i, j, sbox);
                int rand = sbox[(sbox[i] + sbox[j]) % 256];
                code[n] = (byte)(rand ^ msg[n]);
            }
            readLock.unlock();
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.unlock();
            throw throwable;
        }
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    public void setKey(String key) throws CryptoException {
        int length = key.length();
        if (length < 5 || length >= 256) {
            throw new CryptoException("Key length has to be between {} and {}", 5, 255);
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            void var1_1;
            this.sbox = this.initSBox(StrUtil.utf8Bytes((CharSequence)var1_1));
            writeLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int[] initSBox(byte[] key) {
        void var2_2;
        int[] sbox = new int[256];
        int j = 0;
        int i = 0;
        while (i < 256) {
            int n = i++;
            sbox[n] = n;
        }
        for (i = 0; i < 256; ++i) {
            j = (j + sbox[i] + key[i % key.length] & 0xFF) % 256;
            this.swap(i, j, sbox);
        }
        return var2_2;
    }

    private void swap(int i, int j, int[] sbox) {
        int temp = sbox[i];
        sbox[var1_1] = sbox[j];
        var3_3[var2_2] = temp;
    }
}

