/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.otp;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.otp.HOTP;
import java.time.Duration;
import java.time.Instant;

public class TOTP
extends HOTP {
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Duration timeStep;

    /*
     * WARNING - void declaration
     */
    public TOTP(byte[] key) {
        this(DEFAULT_TIME_STEP, (byte[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TOTP(Duration timeStep, byte[] key) {
        this((Duration)var1_1, 6, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TOTP(Duration timeStep, int passwordLength, byte[] key) {
        this((Duration)var1_1, (int)var2_2, HOTP_HMAC_ALGORITHM, (byte[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TOTP(Duration timeStep, int passwordLength, HmacAlgorithm algorithm, byte[] key) {
        super((int)var2_2, (HmacAlgorithm)var3_3, key);
        void var1_1;
        void var3_3;
        void var2_2;
        this.timeStep = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int generate(Instant timestamp) {
        void var1_1;
        return this.generate(var1_1.toEpochMilli() / this.timeStep.toMillis());
    }

    public boolean validate(Instant timestamp, int offsetSize, int code) {
        if (offsetSize == 0) {
            return this.generate(timestamp) == code;
        }
        for (int i = -offsetSize; i <= offsetSize; ++i) {
            if (this.generate(timestamp.plus(this.getTimeStep().multipliedBy(i))) != code) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String generateGoogleSecretKey(String account, int numBytes) {
        void var1_1;
        String string;
        return StrUtil.format("otpauth://totp/{}?secret={}", string, TOTP.generateSecretKey((int)var1_1));
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

