/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.mac;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.digest.mac.MacEngine;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;

public class Mac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MacEngine engine;

    /*
     * WARNING - void declaration
     */
    public Mac(MacEngine engine) {
        void var1_1;
        this.engine = var1_1;
    }

    public MacEngine getEngine() {
        return this.engine;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return this.digest(StrUtil.bytes((CharSequence)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(String data) {
        void var1_1;
        return this.digest((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String digestBase64(String data, boolean isUrlSafe) {
        void var2_2;
        void var1_1;
        return this.digestBase64((String)var1_1, CharsetUtil.CHARSET_UTF_8, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String digestBase64(String data, Charset charset, boolean isUrlSafe) {
        void var1_1;
        void var3_3;
        void var2_2;
        byte[] digest = this.digest(data, (Charset)var2_2);
        if (var3_3 != false) {
            return Base64.encodeUrlSafe(digest);
        }
        return Base64.encode((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((String)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(String data) {
        void var1_1;
        return this.digestHex((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(File file) throws CryptoException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)byArray);
            byArray = this.digest(in);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(in);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(File file) {
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(byte[] data) {
        void var1_1;
        return this.digest(new ByteArrayInputStream((byte[])var1_1), -1);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(byte[] data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(InputStream data) {
        void var1_1;
        return this.digest((InputStream)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(InputStream data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((InputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(InputStream data, int bufferLength) {
        void var2_2;
        void var1_1;
        return this.engine.digest((InputStream)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(InputStream data, int bufferLength) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((InputStream)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public boolean verify(byte[] digest, byte[] digestToCompare) {
        void var2_2;
        return MessageDigest.isEqual(digest, (byte[])var2_2);
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

