/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.Digester;
import java.security.MessageDigest;

public class DigesterFactory {
    private final MessageDigest prototype;
    private final boolean cloneSupport;

    public static DigesterFactory ofJdk(String algorithm) {
        return DigesterFactory.of(SecureUtil.createJdkMessageDigest(algorithm));
    }

    public static DigesterFactory of(String algorithm) {
        return DigesterFactory.of(SecureUtil.createMessageDigest(algorithm));
    }

    public static DigesterFactory of(MessageDigest messageDigest) {
        MessageDigest messageDigest2;
        return new DigesterFactory(messageDigest2);
    }

    /*
     * WARNING - void declaration
     */
    private DigesterFactory(MessageDigest messageDigest) {
        void var1_1;
        this.prototype = messageDigest;
        this.cloneSupport = DigesterFactory.checkCloneSupport((MessageDigest)var1_1);
    }

    public Digester createDigester() {
        return new Digester(this.createMessageDigester());
    }

    public MessageDigest createMessageDigester() {
        if (this.cloneSupport) {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return SecureUtil.createJdkMessageDigest(this.prototype.getAlgorithm());
    }

    private static boolean checkCloneSupport(MessageDigest messageDigest) {
        try {
            messageDigest.clone();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
    }
}

