/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class Digester
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MessageDigest digest;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    /*
     * WARNING - void declaration
     */
    public Digester(DigestAlgorithm algorithm) {
        this(var1_1.getValue());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Digester(String algorithm) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Digester(DigestAlgorithm algorithm, Provider provider) {
        void var2_2;
        void var1_1;
        this.init(var1_1.getValue(), (Provider)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Digester(String algorithm, Provider provider) {
        void var2_2;
        void var1_1;
        this.init((String)var1_1, (Provider)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Digester(MessageDigest messageDigest) {
        void var1_1;
        this.digest = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Digester init(String algorithm, Provider provider) {
        if (provider == null) {
            this.digest = SecureUtil.createMessageDigest(algorithm);
        } else {
            try {
                void var2_3;
                this.digest = MessageDigest.getInstance(algorithm, (Provider)var2_3);
            }
            catch (NoSuchAlgorithmException e) {
                void var1_2;
                throw new CryptoException((Throwable)var1_2);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Digester setSalt(byte[] salt) {
        void var1_1;
        this.salt = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Digester setSaltPosition(int saltPosition) {
        void var1_1;
        this.saltPosition = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Digester setDigestCount(int digestCount) {
        void var1_1;
        this.digestCount = var1_1;
        return this;
    }

    public Digester reset() {
        this.digest.reset();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(String data, String charsetName) {
        void var2_2;
        void var1_1;
        return this.digest((String)var1_1, CharsetUtil.charset((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return this.digest(StrUtil.bytes((CharSequence)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(String data) {
        void var1_1;
        return this.digest((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(String data, String charsetName) {
        void var2_2;
        void var1_1;
        return this.digestHex((String)var1_1, CharsetUtil.charset((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((String)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(String data) {
        void var1_1;
        return this.digestHex((String)var1_1, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(File file) throws CryptoException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)byArray);
            byArray = this.digest(in);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(in);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(File file) {
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(byte[] data) {
        void var1_1;
        byte[] result;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data);
        } else if (this.saltPosition >= result.length) {
            result = this.doDigest(result, this.salt);
        } else if (ArrayUtil.isNotEmpty(this.salt)) {
            this.digest.update(result, 0, this.saltPosition);
            this.digest.update(this.salt);
            this.digest.update(result, this.saltPosition, result.length - this.saltPosition);
            result = this.digest.digest();
        } else {
            result = this.doDigest(new byte[][]{result});
        }
        return this.resetAndRepeatDigest((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(byte[] data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(InputStream data) {
        void var1_1;
        return this.digest((InputStream)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(InputStream data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((InputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] digest(InputStream data, int bufferLength) throws IORuntimeException {
        void var1_1;
        if (bufferLength <= 0) {
            bufferLength = 8192;
        }
        try {
            void var2_3;
            byte[] result;
            result = ArrayUtil.isEmpty(this.salt) ? this.digestWithoutSalt(data, bufferLength) : this.digestWithSalt((InputStream)result, (int)var2_3);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.resetAndRepeatDigest((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(InputStream data, int bufferLength) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.digest((InputStream)var1_1, (int)var2_2));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        byte[] buffer = new byte[bufferLength];
        while ((read = data.read(buffer, 0, bufferLength)) >= 0) {
            this.digest.update(buffer, 0, read);
        }
        return this.digest.digest();
    }

    private byte[] digestWithSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        if (this.saltPosition <= 0) {
            this.digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read = data.read(buffer, 0, bufferLength)) >= 0) {
            if (this.saltPosition > 0 && (total += read) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    this.digest.update(buffer, 0, total - this.saltPosition);
                }
                this.digest.update(this.salt);
                this.digest.update(buffer, total - this.saltPosition, read);
                continue;
            }
            this.digest.update(buffer, 0, read);
        }
        if (total < this.saltPosition) {
            this.digest.update(this.salt);
        }
        return this.digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        byte[][] byArray = datas;
        int n = datas.length;
        for (int i = 0; i < n; ++i) {
            byte[] data = byArray[i];
            if (data == null) continue;
            this.digest.update(data);
        }
        return this.digest.digest();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] resetAndRepeatDigest(byte[] digestData) {
        void var1_1;
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return var1_1;
    }
}

