/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.BaseAsymmetric;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;

public class Sign
extends BaseAsymmetric<Sign> {
    private static final long serialVersionUID = 1L;
    protected Signature signature;

    /*
     * WARNING - void declaration
     */
    public Sign(SignAlgorithm algorithm) {
        this((SignAlgorithm)var1_1, (byte[])null, (byte[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(String algorithm) {
        this((String)var1_1, (byte[])null, (byte[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(SignAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(var1_1.getValue(), SecureUtil.decode((String)var2_2), SecureUtil.decode((String)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(var1_1.getValue(), (byte[])var2_2, (byte[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(SignAlgorithm algorithm, KeyPair keyPair) {
        this(var1_1.getValue(), (KeyPair)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(var1_1.getValue(), (PrivateKey)var2_2, (PublicKey)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this((String)var1_1, Base64.decode((CharSequence)var2_2), Base64.decode((CharSequence)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        void var3_3;
        void var1_1;
        void var2_2;
        String string = algorithm;
        this(string, SecureUtil.generatePrivateKey(string, (byte[])var2_2), SecureUtil.generatePublicKey((String)var1_1, (byte[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Sign(String algorithm, KeyPair keyPair) {
        this((String)var1_1, keyPair.getPrivate(), var2_2.getPublic());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sign(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.signature = SecureUtil.createSignature(algorithm);
        super.init((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Sign setParameter(AlgorithmParameterSpec params) {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            void var1_2;
            throw new CryptoException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return this.sign(StrUtil.bytes((CharSequence)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(String data) {
        void var1_1;
        return this.sign((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String signHex(String data, Charset charset) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.sign((String)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String signHex(String data) {
        void var1_1;
        return this.signHex((String)var1_1, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(byte[] data) {
        void var1_1;
        return this.sign(new ByteArrayInputStream((byte[])var1_1), -1);
    }

    /*
     * WARNING - void declaration
     */
    public String signHex(byte[] data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.sign((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String signHex(InputStream data) {
        void var1_1;
        return HexUtil.encodeHexStr(this.sign((InputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(InputStream data) {
        void var1_1;
        return this.sign((InputStream)var1_1, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public String digestHex(InputStream data, int bufferLength) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.sign((InputStream)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(InputStream data, int bufferLength) {
        if (bufferLength <= 0) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        this.lock.lock();
        try {
            byte[] result;
            this.signature.initSign(this.privateKey);
            try {
                int read = data.read(buffer, 0, bufferLength);
                while (read >= 0) {
                    this.signature.update(buffer, 0, read);
                    read = data.read(buffer, 0, bufferLength);
                }
                result = this.signature.sign();
            }
            catch (Exception e) {
                throw new CryptoException(e);
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            void var1_2;
            throw new CryptoException((Throwable)var1_2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean verify(byte[] data2, byte[] sign) {
        this.lock.lock();
        try {
            void var2_5;
            this.signature.initVerify(this.publicKey);
            this.signature.update(data2);
            boolean data2 = this.signature.verify((byte[])var2_5);
            return data2;
        }
        catch (Exception e) {
            void var1_3;
            throw new CryptoException((Throwable)var1_3);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    /*
     * WARNING - void declaration
     */
    public Sign setSignature(Signature signature) {
        void var1_1;
        this.signature = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Sign setCertificate(Certificate certificate) {
        void var1_1;
        void var2_2;
        boolean[] keyUsageInfo;
        void var3_3;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollUtil.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && var3_3.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && var2_2[0] == false) {
            throw new CryptoException("Wrong key usage");
        }
        this.publicKey = var1_1.getPublicKey();
        return this;
    }
}

