/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class SM2
extends AbstractAsymmetricCrypto<SM2> {
    private static final long serialVersionUID = 1L;
    private static final String ALGORITHM_SM2 = "SM2";
    protected SM2Engine engine;
    protected SM2Signer signer;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;
    private DSAEncoding encoding = StandardDSAEncoding.INSTANCE;
    private Digest digest = new SM3Digest();
    private SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;

    public SM2() {
        this((byte[])null, (byte[])null);
    }

    /*
     * WARNING - void declaration
     */
    public SM2(String privateKeyStr, String publicKeyStr) {
        this(SecureUtil.decode((String)var1_1), SecureUtil.decode((String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SM2(byte[] privateKey, byte[] publicKey) {
        this(ECKeyUtil.decodePrivateKeyParams((byte[])var1_1), ECKeyUtil.decodePublicKeyParams((byte[])var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        this(BCUtil.toParams(privateKey), BCUtil.toParams(publicKey));
        if (privateKey != null) {
            void var1_1;
            this.privateKey = var1_1;
        }
        if (publicKey != null) {
            void var2_2;
            this.publicKey = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SM2(String privateKeyHex, String publicKeyPointXHex, String publicKeyPointYHex) {
        this(BCUtil.toSm2Params((String)var1_1), BCUtil.toSm2Params((String)var2_2, (String)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SM2(byte[] privateKey, byte[] publicKeyPointX, byte[] publicKeyPointY) {
        this(BCUtil.toSm2Params((byte[])var1_1), BCUtil.toSm2Params((byte[])var2_2, (byte[])var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        super(ALGORITHM_SM2, null, null);
        void var2_2;
        void var1_1;
        this.privateKeyParams = var1_1;
        this.publicKeyParams = var2_2;
        this.init();
    }

    public SM2 init() {
        if (this.privateKeyParams == null && this.publicKeyParams == null) {
            super.initKeys();
            this.privateKeyParams = BCUtil.toParams(this.privateKey);
            this.publicKeyParams = BCUtil.toParams(this.publicKey);
        }
        return this;
    }

    @Override
    public SM2 initKeys() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encrypt(byte[] data) throws CryptoException {
        void var1_1;
        return this.encrypt((byte[])var1_1, KeyType.PublicKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws CryptoException {
        void var2_2;
        void var1_1;
        if (KeyType.PublicKey != keyType) {
            throw new IllegalArgumentException("Encrypt is only support by public key");
        }
        return this.encrypt((byte[])var1_1, (CipherParameters)new ParametersWithRandom(this.getCipherParameters((KeyType)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encrypt(byte[] data, CipherParameters pubKeyParameters) throws CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            void var3_5;
            void var2_4;
            engine.init(true, (CipherParameters)var2_4);
            data = var3_5.processBlock(data, 0, data.length);
            return data;
        }
        catch (InvalidCipherTextException e) {
            void var1_2;
            throw new CryptoException((Throwable)var1_2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decrypt(byte[] data) throws CryptoException {
        void var1_1;
        return this.decrypt((byte[])var1_1, KeyType.PrivateKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) throws CryptoException {
        void var2_2;
        void var1_1;
        if (KeyType.PrivateKey != keyType) {
            throw new IllegalArgumentException("Decrypt is only support by private key");
        }
        return this.decrypt((byte[])var1_1, this.getCipherParameters((KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decrypt(byte[] data, CipherParameters privateKeyParameters) throws CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            void var3_5;
            void var2_4;
            engine.init(false, (CipherParameters)var2_4);
            data = var3_5.processBlock(data, 0, data.length);
            return data;
        }
        catch (InvalidCipherTextException e) {
            void var1_2;
            throw new CryptoException((Throwable)var1_2);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String signHex(String dataHex) {
        void var1_1;
        return this.signHex((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(byte[] data) {
        void var1_1;
        return this.sign((byte[])var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public String signHex(String dataHex, String idHex) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.sign(HexUtil.decodeHex((String)var1_1), HexUtil.decodeHex((String)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sign(byte[] data, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            void var3_4;
            byte[] byArray;
            ParametersWithRandom param = new ParametersWithRandom(this.getCipherParameters(KeyType.PrivateKey));
            if (id != null) {
                void var2_3;
                param = new ParametersWithID((CipherParameters)param, (byte[])var2_3);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, byArray.length);
            byArray = var3_4.generateSignature();
            return byArray;
        }
        catch (org.bouncycastle.crypto.CryptoException e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean verifyHex(String dataHex, String signHex) {
        void var2_2;
        void var1_1;
        return this.verifyHex((String)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean verify(byte[] data, byte[] sign) {
        void var2_2;
        void var1_1;
        return this.verify((byte[])var1_1, (byte[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean verifyHex(String dataHex, String signHex, String idHex) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.verify(HexUtil.decodeHex((String)var1_1), HexUtil.decodeHex((String)var2_2), HexUtil.decodeHex((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            void var2_4;
            void var1_1;
            CipherParameters param = this.getCipherParameters(KeyType.PublicKey);
            if (id != null) {
                void var3_5;
                param = new ParametersWithID(param, (byte[])var3_5);
            }
            signer.init(false, param);
            signer.update(data, 0, ((void)var1_1).length);
            boolean bl = signer.verifySignature((byte[])var2_4);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SM2 setPrivateKey(PrivateKey privateKey) {
        void var1_1;
        super.setPrivateKey(privateKey);
        this.privateKeyParams = BCUtil.toParams((PrivateKey)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SM2 setPrivateKeyParams(ECPrivateKeyParameters privateKeyParams) {
        void var1_1;
        this.privateKeyParams = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SM2 setPublicKey(PublicKey publicKey) {
        void var1_1;
        super.setPublicKey(publicKey);
        this.publicKeyParams = BCUtil.toParams((PublicKey)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SM2 setPublicKeyParams(ECPublicKeyParameters publicKeyParams) {
        void var1_1;
        this.publicKeyParams = var1_1;
        return this;
    }

    public SM2 usePlainEncoding() {
        return this.setEncoding((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public SM2 setEncoding(DSAEncoding encoding) {
        void var1_1;
        this.encoding = var1_1;
        this.signer = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SM2 setDigest(Digest digest) {
        void var1_1;
        this.digest = var1_1;
        this.engine = null;
        this.signer = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SM2 setMode(SM2Engine.Mode mode) {
        void var1_1;
        this.mode = var1_1;
        this.engine = null;
        return this;
    }

    public byte[] getD() {
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.getDBigInteger());
    }

    public String getDHex() {
        return new String(Hex.encode((byte[])this.getD()));
    }

    public BigInteger getDBigInteger() {
        return this.privateKeyParams.getD();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getQ(boolean isCompressed) {
        void var1_1;
        return this.publicKeyParams.getQ().getEncoded((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private CipherParameters getCipherParameters(KeyType keyType) {
        void var1_1;
        switch (1.$SwitchMap$cn$hutool$crypto$asymmetric$KeyType[var1_1.ordinal()]) {
            case 1: {
                Assert.notNull(this.publicKeyParams, "PublicKey must be not null !", new Object[0]);
                return this.publicKeyParams;
            }
            case 2: {
                Assert.notNull(this.privateKeyParams, "PrivateKey must be not null !", new Object[0]);
                return this.privateKeyParams;
            }
        }
        return null;
    }

    private SM2Engine getEngine() {
        if (this.engine == null) {
            Assert.notNull(this.digest, "digest must be not null !", new Object[0]);
            this.engine = new SM2Engine(this.digest, this.mode);
        }
        this.digest.reset();
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (this.signer == null) {
            Assert.notNull(this.digest, "digest must be not null !", new Object[0]);
            this.signer = new SM2Signer(this.encoding, this.digest);
        }
        this.digest.reset();
        return this.signer;
    }
}

